/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.broker;

import ch.icosys.popjava.core.broker.Request;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class RequestQueue {
    private final Lock lock = new ReentrantLock();
    private final Condition canPick = this.lock.newCondition();
    private final Condition canInsert = this.lock.newCondition();
    private Request nextRequestToPick = null;
    private Request mutexRequest = null;
    private final LinkedList<Request> concurrentRequests = new LinkedList();
    private final LinkedList<Request> sequentialRequests = new LinkedList();
    private final LinkedList<Request> waitingRequests = new LinkedList();
    private boolean nextRequestIsConc = false;
    public static final int DEFAULT_REQUEST_QUEUE_SIZE = 250;
    private int maxQueue = 250;

    public synchronized int size() {
        return this.concurrentRequests.size() + this.sequentialRequests.size() + (this.mutexRequest == null ? 0 : 1) + this.waitingRequests.size();
    }

    public synchronized int getMaxQueue() {
        return this.maxQueue;
    }

    public synchronized void setMaxQueue(int maxQueue) {
        this.maxQueue = maxQueue;
    }

    public boolean add(Request request) {
        this.lock.lock();
        try {
            if (this.mutexRequest == null) {
                if (request.isMutex()) {
                    this.mutexRequest = request;
                } else if (request.isConcurrent()) {
                    while (this.size() >= this.maxQueue) {
                        this.canInsert.await();
                    }
                    this.concurrentRequests.add(request);
                } else if (request.isSequential()) {
                    while (this.size() >= this.maxQueue) {
                        this.canInsert.await();
                    }
                    this.sequentialRequests.add(request);
                }
            } else {
                while (this.size() >= this.maxQueue) {
                    this.canInsert.await();
                }
                this.waitingRequests.add(request);
            }
            this.canPick();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Request pick(int time, TimeUnit timeUnit) {
        Request pickedRequest = null;
        this.lock.lock();
        try {
            boolean waitSuccess;
            boolean bl = waitSuccess = this.nextRequestToPick != null || this.canPick.await(time, timeUnit);
            if (waitSuccess) {
                pickedRequest = this.nextRequestToPick;
                pickedRequest.setStatus(1);
                if (pickedRequest.isMutex() || pickedRequest.isSequential()) {
                    // empty if block
                }
                this.nextRequestToPick = null;
                this.canPick();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.lock.unlock();
        }
        return pickedRequest;
    }

    public boolean remove(Request request) {
        this.lock.lock();
        try {
            if (request.isMutex() && this.mutexRequest == request) {
                Request waitingRequest;
                this.mutexRequest = null;
                while ((waitingRequest = this.waitingRequests.poll()) != null) {
                    if (waitingRequest.isMutex()) {
                        this.mutexRequest = waitingRequest;
                        break;
                    }
                    if (waitingRequest.isConcurrent()) {
                        this.concurrentRequests.add(waitingRequest);
                        continue;
                    }
                    if (!waitingRequest.isSequential()) continue;
                    this.sequentialRequests.add(waitingRequest);
                }
            } else if (request.isSequential()) {
                this.sequentialRequests.remove(request);
            } else if (request.isConcurrent()) {
                this.concurrentRequests.remove(request);
            } else if (this.waitingRequests.contains(request)) {
                this.waitingRequests.remove(request);
            }
            this.canPick();
            this.canInsert.signal();
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    private boolean canPick() {
        if (this.nextRequestToPick == null) {
            if (this.sequentialRequests.isEmpty() && this.concurrentRequests.isEmpty()) {
                if (this.mutexRequest != null && this.mutexRequest.getStatus() == 0) {
                    this.nextRequestToPick = this.mutexRequest;
                }
            } else if (this.sequentialRequests.isEmpty()) {
                for (Request request : this.concurrentRequests) {
                    if (request.getStatus() != 0) continue;
                    this.nextRequestToPick = request;
                    this.nextRequestIsConc = false;
                    break;
                }
            } else if (this.concurrentRequests.isEmpty()) {
                if (this.sequentialRequests.getFirst().getStatus() == 0) {
                    this.nextRequestToPick = this.sequentialRequests.getFirst();
                    this.nextRequestIsConc = true;
                }
            } else if (!this.nextRequestIsConc && this.sequentialRequests.getFirst().getStatus() == 0) {
                this.nextRequestToPick = this.sequentialRequests.getFirst();
                this.nextRequestIsConc = true;
            } else {
                for (Request request : this.concurrentRequests) {
                    if (request.getStatus() != 0) continue;
                    this.nextRequestToPick = request;
                    this.nextRequestIsConc = false;
                    break;
                }
            }
        }
        if (this.nextRequestToPick != null) {
            this.canPick.signal();
            return true;
        }
        return false;
    }

    public synchronized boolean clear() {
        this.nextRequestToPick = null;
        this.mutexRequest = null;
        this.concurrentRequests.clear();
        this.sequentialRequests.clear();
        this.waitingRequests.clear();
        return true;
    }
}

