/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.buffer;

import ch.icosys.popjava.core.buffer.BufferFactory;
import ch.icosys.popjava.core.buffer.BufferRawFactory;
import ch.icosys.popjava.core.buffer.BufferXDRFactory;
import ch.icosys.popjava.core.system.POPJavaConfiguration;
import ch.icosys.popjava.core.system.XMLWorker;
import ch.icosys.popjava.core.util.LogWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class BufferFactoryFinder {
    private final ConcurrentHashMap<String, BufferFactory> bufferFactoryList = new ConcurrentHashMap();
    private URLClassLoader urlClassLoader = null;
    private static BufferFactoryFinder currentInstance = null;
    private final String PackageNodeName = "Package";
    private final String JarAttributeName = "JarFile";
    private final String BufferFactoryNodeName = "BufferFactory";

    protected BufferFactoryFinder() {
        BufferRawFactory rawBufferFactory = new BufferRawFactory();
        this.bufferFactoryList.put(rawBufferFactory.getBufferName(), rawBufferFactory);
        BufferXDRFactory xdrBufferFactory = new BufferXDRFactory();
        this.bufferFactoryList.put(xdrBufferFactory.getBufferName(), xdrBufferFactory);
        String pluginLocation = POPJavaConfiguration.getPopPluginLocation();
        if (pluginLocation.length() > 0) {
            this.loadBufferMap(pluginLocation);
        }
    }

    public static BufferFactoryFinder getInstance() {
        if (currentInstance == null) {
            currentInstance = new BufferFactoryFinder();
        }
        return currentInstance;
    }

    public void loadBufferMap(String pluginLocation) {
        String schemaLocation;
        XMLWorker xw = new XMLWorker();
        String bufferMapLocation = pluginLocation + File.separator + "pop_buffer.xml";
        if (!xw.isValid(bufferMapLocation, schemaLocation = pluginLocation + File.separator + "pop_buffer.xsd")) {
            LogWriter.printDebug("The buffer plugin map is not valid");
            return;
        }
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(bufferMapLocation));
            Element factoryListElement = document.getDocumentElement();
            NodeList list = factoryListElement.getChildNodes();
            for (int index = 0; index < list.getLength(); ++index) {
                Node node = list.item(index);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("Package")) continue;
                Element packageElement = (Element)node;
                String jarFileName = packageElement.getAttribute("JarFile");
                String jarFileLocation = pluginLocation + File.separator + jarFileName;
                File jarFile = new File(jarFileLocation);
                try {
                    URL[] urls = new URL[]{jarFile.toURI().toURL()};
                    this.urlClassLoader = new URLClassLoader(urls);
                }
                catch (MalformedURLException ex) {
                    continue;
                }
                for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    String factoryName;
                    if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("BufferFactory") || (factoryName = childNode.getTextContent()) == null || factoryName.length() <= 0) continue;
                    this.loadPlugin(factoryName, this.urlClassLoader);
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    public BufferFactory findFactory(String factoryName) {
        if (this.bufferFactoryList.containsKey(factoryName = factoryName.toLowerCase())) {
            return this.bufferFactoryList.get(factoryName);
        }
        return null;
    }

    private BufferFactory loadPlugin(String bufferFactoryName, URLClassLoader urlClassLoader) {
        bufferFactoryName = bufferFactoryName.trim();
        if (urlClassLoader == null || bufferFactoryName.length() == 0) {
            return null;
        }
        BufferFactory bufferFactory = null;
        try {
            Class<?> bufferClass = Class.forName(bufferFactoryName, true, urlClassLoader);
            Constructor<?> constructor = bufferClass.getConstructor(new Class[0]);
            bufferFactory = (BufferFactory)constructor.newInstance(new Object[0]);
            if (!this.bufferFactoryList.containsKey(bufferFactory.getBufferName())) {
                this.bufferFactoryList.put(bufferFactory.getBufferName(), bufferFactory);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return bufferFactory;
    }

    public String getSupportingBuffer() {
        StringBuilder supportingBuffer = new StringBuilder();
        Enumeration<String> keys = this.bufferFactoryList.keys();
        String key = "";
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            supportingBuffer.append(key).append(" ");
        }
        supportingBuffer = new StringBuilder(supportingBuffer.toString().trim());
        return supportingBuffer.toString();
    }
}

