/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.buffer;

import ch.icosys.popjava.core.base.MessageHeader;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.util.LogWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.StandardCharsets;

public class BufferRaw
extends POPBuffer {
    public static final int BUFFER_LENGTH = 16384;
    protected ByteBuffer buffer = ByteBuffer.allocate(16384);

    public BufferRaw() {
        this(new MessageHeader());
    }

    public BufferRaw(MessageHeader messageHeader) {
        super(messageHeader);
        this.buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.buffer.position(28);
        this.size = 28;
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }

    @Override
    public MessageHeader extractHeader() {
        this.messageHeader = new MessageHeader();
        if (this.buffer.limit() >= 28) {
            int connectionID = this.getInt(4);
            this.messageHeader.setConnectionID(connectionID);
            int requestId = this.getInt(8);
            this.messageHeader.setRequestID(requestId);
            int requestType = this.getInt(12);
            this.messageHeader.setRequestType(requestType);
            switch (requestType) {
                case 0: {
                    this.messageHeader.setClassId(this.getInt(16));
                    this.messageHeader.setMethodId(this.getInt(20));
                    this.messageHeader.setSenmatics(this.getInt(24));
                    break;
                }
                case 2: {
                    this.messageHeader.setExceptionCode(this.getInt(16));
                    break;
                }
                case 1: {
                    break;
                }
            }
            this.position(28);
        }
        return this.messageHeader;
    }

    @Override
    public int packMessageHeader() {
        int index = 0;
        for (index = 0; index < 7; ++index) {
            this.putInt(index * 4, 0);
        }
        int type = this.messageHeader.getRequestType();
        this.putInt(0, this.size());
        this.putInt(4, this.messageHeader.getConnectionID());
        this.putInt(8, this.messageHeader.getRequestID());
        this.putInt(12, type);
        switch (type) {
            case 0: {
                this.putInt(16, this.messageHeader.getClassId());
                this.putInt(20, this.messageHeader.getMethodId());
                this.putInt(24, this.messageHeader.getSemantics());
                break;
            }
            case 2: {
                this.putInt(16, this.messageHeader.getExceptionCode());
                break;
            }
            case 1: {
                break;
            }
        }
        return 0;
    }

    @Override
    public boolean getBoolean() {
        int value = this.getInt();
        if (value == 0) {
            return false;
        }
        if (value == 1) {
            return true;
        }
        LogWriter.writeDebugInfo("Decoding boolean using wrong buffer type " + this.getClass().getName());
        return value != 0;
    }

    @Override
    public float getFloat() {
        return this.buffer.getFloat();
    }

    @Override
    public int getInt() {
        return this.buffer.getInt();
    }

    public int getInt(int index) {
        return this.buffer.getInt(index);
    }

    @Override
    public char getChar() {
        char c = this.buffer.getChar();
        this.position(this.position() + 2);
        return c;
    }

    @Override
    public double getDouble() {
        return this.buffer.getDouble();
    }

    @Override
    public long getLong() {
        return this.buffer.getLong();
    }

    @Override
    public String getString() {
        int stringLength = this.getInt();
        if (stringLength < 0) {
            throw new RuntimeException("Invalid string length: " + stringLength);
        }
        if (stringLength == 0) {
            return "";
        }
        try {
            byte[] data = new byte[stringLength - 1];
            this.buffer.get(data, 0, data.length);
            int padding = 1;
            if (stringLength % 4 != 0) {
                padding += 4 - stringLength % 4;
            }
            this.position(this.position() + padding);
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return "";
        }
    }

    private String getStringLength(int length) {
        try {
            byte[] data = new byte[length];
            this.buffer.get(data, 0, length);
            if (length % 4 != 0) {
                this.position(this.position() + 4 - length % 4);
            }
            return new String(data, StandardCharsets.UTF_8).trim();
        }
        catch (Exception e) {
            return "";
        }
    }

    @Override
    public void put(byte value) {
        this.resize(4);
        this.buffer.put(value);
        this.buffer.put((byte)0);
        this.buffer.put((byte)0);
        this.buffer.put((byte)0);
    }

    @Override
    public void put(byte[] data) {
        int len = data.length;
        if (len % 4 != 0) {
            len = len + 4 - len % 4;
        }
        this.resize(len);
        this.buffer.put(data);
        if (data.length % 4 != 0) {
            this.position(this.position() + 4 - data.length % 4);
        }
    }

    @Override
    public void put(byte[] data, int offset, int length) {
        this.resize(length);
        this.buffer.put(data, offset, length);
    }

    @Override
    public void putBoolean(boolean value) {
        if (value) {
            this.putInt(1);
        } else {
            this.putInt(0);
        }
    }

    @Override
    public void putChar(char value) {
        this.resize(4);
        this.buffer.putChar(value);
        this.buffer.put((byte)0);
        this.buffer.put((byte)0);
    }

    @Override
    public void putFloat(float value) {
        this.resize(4);
        this.buffer.putFloat(value);
    }

    @Override
    public void putInt(int value) {
        this.resize(4);
        this.buffer.putInt(value);
    }

    public void putInt(int index, int value) {
        this.resize(index, 4);
        this.buffer.putInt(index, value);
    }

    @Override
    public void putDouble(double value) {
        this.resize(8);
        this.buffer.putDouble(value);
    }

    @Override
    public void putLong(long value) {
        this.resize(8);
        this.buffer.putLong(value);
    }

    private static byte[] stringToBytesASCII(String str) {
        return str.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public void putString(String data) {
        if (data != null && data.length() > 0) {
            byte[] bytes = BufferRaw.stringToBytesASCII(data);
            int stringLength = bytes.length + 1;
            int padding = 0;
            if (stringLength % 4 != 0) {
                padding = 4 - stringLength % 4;
            }
            this.resize(stringLength + 4 + padding);
            this.buffer.putInt(stringLength);
            this.buffer.put(bytes);
            for (int i = 0; i < padding + 1; ++i) {
                this.buffer.put((byte)0);
            }
        } else {
            this.putInt(0);
        }
    }

    @Override
    public void reset() {
        this.buffer.clear();
        this.size = 28;
        for (int i = 0; i < this.size; ++i) {
            this.buffer.put((byte)0);
        }
    }

    @Override
    public void resetToReceive() {
        this.buffer.clear();
        this.size = 0;
        this.position(this.size);
    }

    @Override
    public int getTranslatedInteger(byte[] value) {
        return (value[3] & 0xFF) << 24 | (value[2] & 0xFF) << 16 | (value[1] & 0xFF) << 8 | value[0] & 0xFF;
    }

    @Override
    public String toIntString() {
        int position = this.position();
        this.position(0);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size() / 4; ++i) {
            sb.append(this.getInt());
            sb.append('_');
        }
        this.position(position);
        return sb.toString();
    }

    @Override
    public String toCharString() {
        int position = this.position();
        this.position(0);
        StringBuilder sb = new StringBuilder();
        sb.append("Data in bytes:");
        for (int i = 0; i < this.size(); ++i) {
            byte data = this.buffer.get();
            int byteValue = new Integer(data);
            if (byteValue < 0) {
                byteValue = data & 0x80;
                byteValue += data & 0x7F;
            }
            sb.append(byteValue);
            sb.append('_');
        }
        this.position(position);
        return sb.toString();
    }

    public int position() {
        return this.buffer.position();
    }

    public void position(int index) {
        if (index > this.size) {
            this.size = index;
        }
        this.buffer.position(index);
    }

    protected int limit() {
        return this.buffer.limit();
    }

    private void resizeBuffer(int newCapacity) {
        ByteBuffer tempBuffer = ByteBuffer.allocate(newCapacity);
        tempBuffer.order(this.buffer.order());
        tempBuffer.put(this.buffer.array(), 0, this.buffer.position());
        this.buffer = tempBuffer;
    }

    public void resize(int moreCapacity) {
        this.size += moreCapacity;
        int position = this.position() + moreCapacity;
        if (position >= this.buffer.capacity()) {
            int newCapacity = position * 2;
            if (position > 0x3FFFFFFF) {
                newCapacity = Integer.MAX_VALUE;
            }
            this.resizeBuffer(newCapacity);
        }
    }

    public void resize(int position, int moreCapacity) {
        int capacity;
        if ((position += moreCapacity) > this.size) {
            this.size = position;
        }
        if (position > (capacity = this.buffer.capacity()) / 2) {
            int newCapacity = position * 2;
            ByteBuffer tempBuffer = ByteBuffer.allocate(newCapacity);
            tempBuffer.order(this.buffer.order());
            tempBuffer.put(this.buffer);
            this.buffer = tempBuffer;
        }
    }

    @Override
    public void putBooleanArray(boolean[] value) {
        int[] transfert = new int[value.length];
        for (int i = 0; i < value.length; ++i) {
            transfert[i] = value[i] ? 1 : 0;
        }
        this.putIntArray(transfert);
    }

    @Override
    public void putDoubleArray(double[] value) {
        int arrayLength = 0;
        if (value != null) {
            arrayLength = value.length;
        }
        this.putInt(arrayLength);
        if (arrayLength > 0) {
            this.resize(arrayLength * 8);
            DoubleBuffer doubleBuffer = this.buffer.asDoubleBuffer();
            doubleBuffer.put(value);
            this.position(this.position() + arrayLength * 8);
        }
    }

    @Override
    public void putFloatArray(float[] value) {
        int arrayLength = 0;
        if (value != null) {
            arrayLength = value.length;
        }
        this.putInt(arrayLength);
        if (arrayLength > 0) {
            this.resize(arrayLength * 1);
            FloatBuffer floatBuffer = this.buffer.asFloatBuffer();
            floatBuffer.put(value);
            this.position(this.position() + arrayLength * 4);
        }
    }

    @Override
    public void putIntArray(int[] value) {
        int arrayLength = 0;
        if (value != null) {
            arrayLength = value.length;
        }
        this.putInt(arrayLength);
        if (arrayLength > 0) {
            this.resize(arrayLength * 4);
            IntBuffer intBuffer = this.buffer.asIntBuffer();
            intBuffer.put(value);
            this.position(this.position() + arrayLength * 4);
        }
    }

    @Override
    public void putLongArray(long[] value) {
        int arrayLength = 0;
        if (value != null) {
            arrayLength = value.length;
        }
        this.putInt(arrayLength);
        if (arrayLength > 0) {
            this.resize(arrayLength * 8);
            LongBuffer longBuffer = this.buffer.asLongBuffer();
            longBuffer.put(value);
            this.position(this.position() + arrayLength * 8);
        }
    }

    @Override
    public byte get() {
        return this.buffer.get();
    }

    @Override
    public boolean[] getBooleanArray(int length) {
        int[] transfert = this.getIntArray(length);
        boolean[] ret = new boolean[transfert.length];
        for (int i = 0; i < transfert.length; ++i) {
            ret[i] = transfert[i] == 1;
        }
        return ret;
    }

    @Override
    public byte[] getByteArray(int length) {
        byte[] result = new byte[length];
        if (length > 0) {
            this.buffer.get(result);
            if (length % 4 != 0) {
                this.buffer.position(this.position() + 4 - length % 4);
            }
        }
        return result;
    }

    @Override
    public double[] getDoubleArray(int length) {
        double[] result = new double[length];
        if (length > 0) {
            DoubleBuffer doubleBuffer = this.buffer.asDoubleBuffer();
            doubleBuffer.get(result);
            this.position(this.position() + length * 8);
        }
        return result;
    }

    @Override
    public float[] getFloatArray(int length) {
        float[] result = new float[length];
        if (length > 0) {
            FloatBuffer floatBuffer = this.buffer.asFloatBuffer();
            floatBuffer.get(result);
            this.position(this.position() + length * 4);
        }
        return result;
    }

    @Override
    public int[] getIntArray(int length) {
        int[] result = new int[length];
        if (length > 0) {
            IntBuffer intBuffer = this.buffer.asIntBuffer();
            intBuffer.get(result);
            this.position(this.position() + length * 4);
        }
        return result;
    }

    @Override
    public long[] getLongArray(int length) {
        long[] result = new long[length];
        if (length > 0) {
            LongBuffer longBuffer = this.buffer.asLongBuffer();
            longBuffer.get(result);
            this.position(this.position() + length * 8);
        }
        return result;
    }

    @Override
    public void putByteArray(byte[] value) {
        if (value != null) {
            this.putInt(value.length);
            this.put(value);
        } else {
            this.putInt(0);
        }
    }

    @Override
    public short getShort() {
        return this.buffer.getShort();
    }

    @Override
    public void putShort(short value) {
        this.resize(2);
        this.buffer.putShort(value);
    }

    @Override
    public short[] getShortArray(int length) {
        short[] result = new short[length];
        ShortBuffer shortBuffer = this.buffer.asShortBuffer();
        shortBuffer.get(result);
        this.position(this.position() + length * 2);
        return result;
    }

    @Override
    public void putShortArray(short[] value) {
        int arrayLength = 0;
        if (value != null) {
            arrayLength = value.length;
        }
        this.putInt(arrayLength);
        if (arrayLength > 0) {
            this.resize(arrayLength * 2);
            ShortBuffer shortBuffer = this.buffer.asShortBuffer();
            shortBuffer.put(value);
            this.position(this.position() + arrayLength * 2);
        }
    }

    @Override
    public char[] getCharArray(int length) {
        String s = this.getStringLength(length);
        return s.toCharArray();
    }

    @Override
    public void putCharArray(char[] value) {
        String arrayAsString = new String(value);
        this.putString(arrayAsString);
    }
}

