/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.buffer;

import ch.icosys.popjava.core.base.MessageHeader;
import ch.icosys.popjava.core.buffer.BufferRaw;
import ch.icosys.popjava.core.util.LogWriter;
import java.nio.ByteOrder;

public class BufferXDR
extends BufferRaw {
    public BufferXDR() {
        this(new MessageHeader());
    }

    public BufferXDR(MessageHeader messageHeader) {
        super(messageHeader);
        this.buffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public void putBoolean(boolean value) {
        if (value) {
            this.putInt(Integer.reverseBytes(1));
        } else {
            this.putInt(0);
        }
    }

    @Override
    public boolean getBoolean() {
        int value = this.getInt();
        if (value == 0) {
            return false;
        }
        if (value == Integer.reverseBytes(1)) {
            return true;
        }
        LogWriter.writeDebugInfo("Decoding boolean using wrong buffer type " + this.getClass().getName());
        return value != 0;
    }

    @Override
    public int getTranslatedInteger(byte[] value) {
        return value[0] << 24 | (value[1] & 0xFF) << 16 | (value[2] & 0xFF) << 8 | value[3] & 0xFF;
    }
}

