/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.buffer;

import ch.icosys.popjava.core.base.MessageHeader;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.combox.Combox;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.dataswaper.IPOPBaseInput;
import ch.icosys.popjava.core.util.LogWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class POPBuffer {
    protected MessageHeader messageHeader;
    protected int size = 0;
    private static final Map<Integer, Constructor<?>> constructorsCache = new ConcurrentHashMap();

    public POPBuffer() {
        this(new MessageHeader());
    }

    public POPBuffer(MessageHeader messageHeader) {
        this.messageHeader = messageHeader;
    }

    public abstract void reset();

    public abstract void put(byte var1);

    public abstract void putBoolean(boolean var1);

    public void put(boolean value) {
        this.putBoolean(value);
    }

    public abstract void putChar(char var1);

    public void put(char value) {
        this.putChar(value);
    }

    public abstract void putInt(int var1);

    public void put(int value) {
        this.putInt(value);
    }

    public abstract void putLong(long var1);

    public void put(long value) {
        this.putLong(value);
    }

    public abstract void putShort(short var1);

    public void put(short value) {
        this.putShort(value);
    }

    public abstract void putFloat(float var1);

    public void put(float value) {
        this.putFloat(value);
    }

    public abstract void putDouble(double var1);

    public void put(double value) {
        this.putDouble(value);
    }

    public abstract void put(byte[] var1);

    public abstract void put(byte[] var1, int var2, int var3);

    public abstract void putByteArray(byte[] var1);

    public abstract void putCharArray(char[] var1);

    public abstract void putBooleanArray(boolean[] var1);

    public abstract void putIntArray(int[] var1);

    public abstract void putShortArray(short[] var1);

    public abstract void putLongArray(long[] var1);

    public abstract void putFloatArray(float[] var1);

    public abstract void putDoubleArray(double[] var1);

    public abstract byte[] getByteArray(int var1);

    public abstract char[] getCharArray(int var1);

    public abstract boolean[] getBooleanArray(int var1);

    public abstract int[] getIntArray(int var1);

    public abstract long[] getLongArray(int var1);

    public abstract short[] getShortArray(int var1);

    public abstract float[] getFloatArray(int var1);

    public abstract double[] getDoubleArray(int var1);

    public abstract void putString(String var1);

    public abstract byte get();

    public abstract boolean getBoolean();

    public abstract char getChar();

    public abstract int getInt();

    public abstract long getLong();

    public abstract short getShort();

    public abstract float getFloat();

    public abstract double getDouble();

    public abstract String getString();

    public abstract byte[] array();

    public abstract int getTranslatedInteger(byte[] var1);

    public abstract MessageHeader extractHeader();

    public abstract void resetToReceive();

    public abstract int packMessageHeader();

    public void setHeader(MessageHeader messageHeader) {
        this.reset();
        this.messageHeader = messageHeader;
    }

    public MessageHeader getHeader() {
        return this.messageHeader;
    }

    public int size() {
        return this.size;
    }

    private Constructor<?> getConstructorForClass(Class<?> c) throws SecurityException, NoSuchMethodException {
        int hash = c.getName().hashCode();
        if (constructorsCache.containsKey(hash)) {
            return constructorsCache.get(hash);
        }
        Constructor<?> constructor = c.getConstructor(new Class[0]);
        constructorsCache.put(hash, constructor);
        return constructor;
    }

    public Object getValue(Class<?> c) throws POPException {
        return this.getValue(null, c);
    }

    /*
     * Exception decompiling
     */
    public Object getValue(Combox sourceCombox, Class<?> c) throws POPException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void putValue(Object o, Class<?> c) throws POPException {
        if (o == null) {
            if (!c.isArray()) throw POPException.throwNullObjectNotAllowException();
            this.putArray(o);
            return;
        }
        if (c.equals(Byte.TYPE) || c.equals(Byte.class)) {
            this.put((Byte)o);
            return;
        }
        if (c.equals(Integer.TYPE) || c.equals(Integer.class)) {
            this.putInt((Integer)o);
            return;
        }
        if (c.equals(Float.TYPE) || c.equals(Float.class)) {
            this.putFloat(((Float)o).floatValue());
            return;
        }
        if (c.equals(Boolean.TYPE) || c.equals(Boolean.class)) {
            this.putBoolean((Boolean)o);
            return;
        }
        if (c.equals(String.class)) {
            this.putString((String)o);
            return;
        }
        if (c.equals(Character.TYPE) || c.equals(Character.class)) {
            this.putChar(((Character)o).charValue());
            return;
        }
        if (c.equals(Long.TYPE) || c.equals(Long.class)) {
            this.putLong((Long)o);
            return;
        }
        if (c.equals(Double.TYPE) || c.equals(Double.class)) {
            this.putDouble((Double)o);
            return;
        }
        if (c.equals(Short.TYPE) || c.equals(Short.class)) {
            this.putShort((Short)o);
            return;
        }
        if (c.isArray()) {
            this.putArray(o);
            return;
        }
        if (IPOPBaseInput.class.isAssignableFrom(c)) {
            try {
                IPOPBaseInput temp = (IPOPBaseInput)o;
                temp.serialize(this);
                return;
            }
            catch (Exception e) {
                LogWriter.writeExceptionLog(e);
                POPException.throwReflectSerializeException(c.getName(), e.getMessage());
            }
            return;
        }
        if (IPOPBase.class.isAssignableFrom(c)) {
            try {
                IPOPBase temp = (IPOPBase)o;
                temp.serialize(this);
                return;
            }
            catch (Exception e) {
                LogWriter.writeExceptionLog(e);
                POPException.throwReflectSerializeException(c.getName(), e.getMessage());
            }
            return;
        }
        if (c.isEnum()) {
            this.putString(((Enum)o).name());
            return;
        }
        if (Serializable.class.isAssignableFrom(c)) {
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 ObjectOutputStream out = new ObjectOutputStream(bos);){
                out.writeObject(o);
                out.flush();
                byte[] objectContent = bos.toByteArray();
                this.putByteArray(objectContent);
                return;
            }
            catch (IOException e) {
                LogWriter.writeExceptionLog(e);
                POPException.throwReflectSerializeException(c.getName(), e.getMessage());
            }
            return;
        }
        POPException.throwReflectSerializeException(c.getName(), "Can not serialize parameter " + c.getName());
    }

    public void putArray(Object o) throws POPException {
        int length = 0;
        if (o == null) {
            this.putInt(-1);
            return;
        }
        Class<?> c = o.getClass();
        if (c.equals(byte[].class)) {
            this.putByteArray((byte[])o);
        } else if (c.equals(int[].class)) {
            this.putIntArray((int[])o);
        } else if (c.equals(float[].class)) {
            this.putFloatArray((float[])o);
        } else if (c.equals(boolean[].class)) {
            this.putBooleanArray((boolean[])o);
        } else if (c.equals(long[].class)) {
            this.putLongArray((long[])o);
        } else if (c.equals(double[].class)) {
            this.putDoubleArray((double[])o);
        } else if (c.equals(short[].class)) {
            this.putShortArray((short[])o);
        } else if (c.equals(char[].class)) {
            this.putCharArray((char[])o);
        } else {
            length = Array.getLength(o);
            this.putInt(length);
            for (int i = 0; i < length; ++i) {
                Object element = Array.get(o, i);
                this.putValue(element, c.getComponentType());
            }
        }
    }

    public <T> T getArray(Class<T> arrayType) throws POPException {
        int length = this.getInt();
        if (length < 0) {
            return null;
        }
        if (arrayType.equals(byte[].class)) {
            return (T)this.getByteArray(length);
        }
        if (arrayType.equals(int[].class)) {
            return (T)this.getIntArray(length);
        }
        if (arrayType.equals(float[].class)) {
            return (T)this.getFloatArray(length);
        }
        if (arrayType.equals(boolean[].class)) {
            return (T)this.getBooleanArray(length);
        }
        if (arrayType.equals(long[].class)) {
            return (T)this.getLongArray(length);
        }
        if (arrayType.equals(double[].class)) {
            return (T)this.getDoubleArray(length);
        }
        if (arrayType.equals(short[].class)) {
            return (T)this.getShortArray(length);
        }
        if (arrayType.equals(char[].class)) {
            return (T)this.getCharArray(length);
        }
        Class<?> elementType = arrayType.getComponentType();
        Object resultArray = Array.newInstance(elementType, length);
        for (int index = 0; index < length; ++index) {
            Object value = this.getValue(elementType);
            Array.set(resultArray, index, value);
            continue;
        }
        return (T)resultArray;
    }

    public void serializeReferenceObject(Class<?> type, Object obj) throws POPException {
        try {
            if (type.isArray()) {
                this.putArray(obj);
            } else if (IPOPBase.class.isAssignableFrom(type)) {
                this.putValue(obj, type);
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            e.printStackTrace();
        }
    }

    public void deserializeReferenceObject(Class<?> type, Object obj) throws POPException {
        try {
            Object array;
            if (IPOPBase.class.isAssignableFrom(type)) {
                IPOPBase base = (IPOPBase)obj;
                base.deserialize(this);
            } else if (type.isArray() && (array = this.getArray(type)) != null) {
                System.arraycopy(array, 0, obj, 0, Array.getLength(array));
            }
        }
        catch (Exception e) {
            LogWriter.writeExceptionLog(e);
        }
    }

    public static void checkAndThrow(int systemErrorCode, POPBuffer buffer) throws POPException {
        switch (systemErrorCode) {
            case 1: {
                throw new POPException(systemErrorCode, Integer.toString(buffer.getInt()));
            }
            case 2: {
                break;
            }
            case 3: {
                throw new POPException(systemErrorCode, Long.toString(buffer.getLong()));
            }
            case 4: {
                throw new POPException(systemErrorCode, "EXCEPTION_ULONG");
            }
            case 5: {
                throw new POPException(systemErrorCode, "EXCEPTION_SHORT");
            }
            case 6: {
                throw new POPException(systemErrorCode, "EXCEPTION_USHORT");
            }
            case 7: {
                throw new POPException(systemErrorCode, Boolean.toString(buffer.getBoolean()));
            }
            case 8: {
                throw new POPException(systemErrorCode, Character.toString(buffer.getChar()));
            }
            case 9: {
                throw new POPException(systemErrorCode, "EXCEPTION_UCHAR");
            }
            case 10: {
                throw new POPException(systemErrorCode, buffer.getString());
            }
            case 11: {
                throw new POPException(systemErrorCode, Float.toString(buffer.getFloat()));
            }
            case 12: {
                throw new POPException(systemErrorCode, Double.toString(buffer.getDouble()));
            }
            case 13: {
                throw new POPException(systemErrorCode, "EXCEPTION_OBJECT");
            }
            case 14: {
                POPException exception = new POPException();
                exception.deserialize(buffer);
                throw new POPException(exception.errorCode, exception.errorMessage + " code " + exception.errorCode);
            }
        }
    }

    public String toIntString() {
        return "";
    }

    public String toCharString() {
        return "";
    }
}

