/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public final class POPByteBuffer {
    private long size;
    private long capacity = 16384L;
    private final ByteOrder order;
    private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>();

    public POPByteBuffer() {
        this(ByteOrder.LITTLE_ENDIAN);
    }

    public POPByteBuffer(ByteOrder order) {
        this.order = order;
        this.size = 0L;
        this.init();
    }

    private void init() {
        if (this.capacity < Integer.MAX_VALUE) {
            ByteBuffer bb = ByteBuffer.allocateDirect((int)this.capacity);
            bb.order(this.order);
            this.buffers.add(bb);
        } else {
            long nbBuffers = this.capacity % Integer.MAX_VALUE + 1L;
            int i = 0;
            while ((long)i < nbBuffers) {
                ByteBuffer bb = ByteBuffer.allocateDirect((int)this.capacity);
                bb.order(this.order);
                this.buffers.add(bb);
                ++i;
            }
        }
    }

    public void resize(long extraBytes) {
        this.size += extraBytes;
        if (this.size <= this.capacity) {
            return;
        }
        ByteBuffer first = this.buffers.get(0);
        if (first.capacity() < Integer.MAX_VALUE) {
            if (this.size > Integer.MAX_VALUE) {
                this.capacity = Integer.MAX_VALUE;
            } else {
                do {
                    this.capacity *= 2L;
                } while (this.size > this.capacity);
                if (this.capacity == 0x80000000L) {
                    this.capacity = Integer.MAX_VALUE;
                }
            }
            ByteBuffer newFirst = ByteBuffer.allocateDirect((int)this.capacity);
            newFirst.order(this.order);
            newFirst.put(first);
            this.buffers.set(0, newFirst);
        }
        if (this.size > this.capacity) {
            this.capacity += Integer.MAX_VALUE;
            long nbBuffers = this.capacity / Integer.MAX_VALUE;
            int i = this.activeBuffers();
            while ((long)i < nbBuffers) {
                if (this.capacity > Integer.MAX_VALUE) {
                    ByteBuffer bb = ByteBuffer.allocateDirect(Integer.MAX_VALUE);
                    bb.order(this.order);
                    this.buffers.add(bb);
                }
                ++i;
            }
        }
    }

    private int whichBuffer(long position) {
        return (int)(position % Integer.MAX_VALUE);
    }

    private int activeBuffers() {
        return this.buffers.size();
    }

    public long capacity() {
        return this.capacity;
    }

    public long position() {
        return 0L;
    }

    public void position(long i) {
    }

    public long size() {
        return this.size;
    }

    public byte get() {
        return 0;
    }

    public ByteBuffer put(byte b) {
        return null;
    }

    public byte get(int i) {
        return 0;
    }

    public ByteBuffer put(int i, byte b) {
        return null;
    }

    public char getChar() {
        return '\u0000';
    }

    public ByteBuffer putChar(char c) {
        return null;
    }

    public char getChar(int i) {
        return '\u0000';
    }

    public ByteBuffer putChar(int i, char c) {
        return null;
    }

    public short getShort() {
        return 0;
    }

    public ByteBuffer putShort(short i) {
        return null;
    }

    public short getShort(int i) {
        return 0;
    }

    public ByteBuffer putShort(int i, short i1) {
        return null;
    }

    public int getInt() {
        return 0;
    }

    public ByteBuffer putInt(int i) {
        return null;
    }

    public int getInt(int i) {
        return 0;
    }

    public ByteBuffer putInt(int i, int i1) {
        return null;
    }

    public long getLong() {
        return 0L;
    }

    public ByteBuffer putLong(long l) {
        return null;
    }

    public long getLong(int i) {
        return 0L;
    }

    public ByteBuffer putLong(int i, long l) {
        return null;
    }

    public float getFloat() {
        return 0.0f;
    }

    public ByteBuffer putFloat(float v) {
        return null;
    }

    public float getFloat(int i) {
        return 0.0f;
    }

    public ByteBuffer putFloat(int i, float v) {
        return null;
    }

    public double getDouble() {
        return 0.0;
    }

    public ByteBuffer putDouble(double v) {
        return null;
    }

    public double getDouble(int i) {
        return 0.0;
    }

    public ByteBuffer putDouble(int i, double v) {
        return null;
    }
}

