/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox;

import ch.icosys.popjava.core.combox.ComboxFactory;
import ch.icosys.popjava.core.combox.socket.raw.ComboxSocketFactory;
import ch.icosys.popjava.core.combox.socket.ssl.ComboxSecureSocketFactory;
import ch.icosys.popjava.core.system.POPJavaConfiguration;
import ch.icosys.popjava.core.system.XMLWorker;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ComboxFactoryFinder {
    private final Map<String, ComboxFactory> comboxFactoryList = new HashMap<String, ComboxFactory>();
    private URLClassLoader urlClassLoader = null;
    private static ComboxFactoryFinder currentInstance = null;
    private final String PackageNodeName = "Package";
    private final String JarAttributeName = "JarFile";
    private final String ComboxFactoryNodeName = "ComboxFactory";
    private final Configuration conf = Configuration.getInstance();

    protected ComboxFactoryFinder() {
        ComboxSocketFactory comboxSocketFactory = new ComboxSocketFactory();
        ComboxSecureSocketFactory comboxSecureSocketFactory = new ComboxSecureSocketFactory();
        this.comboxFactoryList.put(comboxSocketFactory.getComboxName(), comboxSocketFactory);
        this.comboxFactoryList.put(comboxSecureSocketFactory.getComboxName(), comboxSecureSocketFactory);
        String pluginLocation = POPJavaConfiguration.getPopPluginLocation();
        if (pluginLocation.length() > 0) {
            this.loadComboxMap(pluginLocation);
        }
    }

    public static ComboxFactoryFinder getInstance() {
        if (currentInstance == null) {
            currentInstance = new ComboxFactoryFinder();
        }
        return currentInstance;
    }

    public void loadComboxMap(String pluginLocation) {
        String schemaLocation;
        XMLWorker xw = new XMLWorker();
        String comboxMapLocation = pluginLocation + File.separator + "pop_combox.xml";
        if (!xw.isValid(comboxMapLocation, schemaLocation = pluginLocation + File.separator + "pop_combox.xsd")) {
            LogWriter.printDebug("The combox plugin map is not valid");
            return;
        }
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(comboxMapLocation));
            Element factoryListElement = document.getDocumentElement();
            NodeList list = factoryListElement.getChildNodes();
            for (int index = 0; index < list.getLength(); ++index) {
                Node node = list.item(index);
                if (node.getNodeType() != 1 || !node.getNodeName().equals("Package")) continue;
                Element packageElement = (Element)node;
                String jarFileName = packageElement.getAttribute("JarFile");
                String jarFileLocation = pluginLocation + File.separator + jarFileName;
                File jarFile = new File(jarFileLocation);
                try {
                    URL[] urls = new URL[]{jarFile.toURI().toURL()};
                    this.urlClassLoader = new URLClassLoader(urls);
                }
                catch (MalformedURLException ex) {
                    continue;
                }
                for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    String factoryName;
                    if (childNode.getNodeType() != 1 || !childNode.getNodeName().equals("ComboxFactory") || (factoryName = childNode.getTextContent()) == null || factoryName.length() <= 0) continue;
                    this.loadPlugin(factoryName, this.urlClassLoader);
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
    }

    public ComboxFactory findFactory(String factoryName) {
        ComboxFactory factory;
        if (factoryName == null || factoryName.isEmpty()) {
            factoryName = this.conf.getDefaultProtocol();
        }
        if ((factory = this.comboxFactoryList.get(factoryName = factoryName.toLowerCase())) != null && factory.isAvailable()) {
            return factory;
        }
        return null;
    }

    public boolean isFactorySecure(String factoryName) {
        if (factoryName == null || factoryName.isEmpty()) {
            return false;
        }
        ComboxFactory factory = this.comboxFactoryList.get(factoryName = factoryName.toLowerCase());
        return factory != null && factory.isSecure();
    }

    public int getFactoryCount() {
        return this.comboxFactoryList.size();
    }

    public ComboxFactory[] getAvailableFactories() {
        ArrayList<ComboxFactory> factories = new ArrayList<ComboxFactory>();
        for (ComboxFactory factory : this.comboxFactoryList.values()) {
            if (!factory.isAvailable()) continue;
            factories.add(factory);
        }
        return factories.toArray(new ComboxFactory[factories.size()]);
    }

    public ComboxFactory get(int index) {
        if (index < 0 || index >= this.getFactoryCount()) {
            return null;
        }
        Set<String> keys = this.comboxFactoryList.keySet();
        String key = "";
        Iterator<String> iterator = keys.iterator();
        for (int currentIndex = 0; iterator.hasNext() && currentIndex <= index; ++currentIndex) {
            key = iterator.next();
        }
        return this.comboxFactoryList.get(key);
    }

    private ComboxFactory loadPlugin(String comboxFactoryName, URLClassLoader urlClassLoader) {
        comboxFactoryName = comboxFactoryName.trim();
        if (urlClassLoader == null || comboxFactoryName.length() == 0) {
            return null;
        }
        ComboxFactory comboxFactory = null;
        try {
            Class<?> comboxClass = Class.forName(comboxFactoryName, true, urlClassLoader);
            Constructor<?> constructor = comboxClass.getConstructor(new Class[0]);
            comboxFactory = (ComboxFactory)constructor.newInstance(new Object[0]);
            if (!this.comboxFactoryList.containsKey(comboxFactory.getComboxName())) {
                this.comboxFactoryList.put(comboxFactory.getComboxName(), comboxFactory);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LogWriter.writeExceptionLog(e);
        }
        return comboxFactory;
    }
}

