/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox.socket;

import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.broker.RequestQueue;
import ch.icosys.popjava.core.combox.Combox;
import ch.icosys.popjava.core.combox.ComboxConnection;
import ch.icosys.popjava.core.combox.ComboxReceiveRequest;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.LinkedList;
import java.util.List;

public abstract class ComboxAcceptSocket<E extends Socket>
implements Runnable {
    public static final int RUNNING = 0;
    public static final int EXIT = 1;
    public static final int ABORT = 2;
    protected final Broker broker;
    protected final RequestQueue requestQueue;
    protected final ServerSocket serverSocket;
    protected int status = 1;
    protected final List<E> concurentConnections = new LinkedList();

    protected ComboxAcceptSocket(Broker broker, RequestQueue requestQueue, ServerSocket serverSocket) {
        this.broker = broker;
        this.requestQueue = requestQueue;
        this.serverSocket = serverSocket;
    }

    public void close() {
        this.status = 1;
        for (Socket s : this.concurentConnections) {
            try {
                s.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (!this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized void setStatus(int status) {
        this.status = status;
    }

    public static void serveConnection(Broker broker, RequestQueue requestQueue, Combox serverClient, int connectionID) {
        ComboxReceiveRequest runnable = new ComboxReceiveRequest(broker, requestQueue, new ComboxConnection(serverClient, connectionID));
        Thread thread = new Thread((Runnable)runnable, "Combox request acceptance " + serverClient.getAccessPoint() + " " + connectionID);
        thread.start();
    }
}

