/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox.socket.raw;

import ch.icosys.popjava.core.baseobject.AccessPoint;
import ch.icosys.popjava.core.combox.ComboxFactory;
import ch.icosys.popjava.core.combox.socket.ComboxSocket;
import ch.icosys.popjava.core.combox.socket.raw.ComboxSocketFactory;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.POPRemoteCaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class ComboxRawSocket
extends ComboxSocket<Socket> {
    protected static final ComboxFactory MY_FACTORY = new ComboxSocketFactory();

    public ComboxRawSocket() {
    }

    public ComboxRawSocket(String networkUUID) {
        super(networkUUID);
    }

    @Override
    protected boolean connectToServer() {
        this.available = false;
        List<AccessPoint> aps = ComboxRawSocket.getSortedAccessPoints(POPSystem.getHostIP(), this.accessPoint, "socket");
        for (int i = 0; i < aps.size() && !this.available; ++i) {
            AccessPoint ap = aps.get(i);
            if (!ap.getProtocol().equals("socket")) continue;
            String host = ap.getHost();
            int port = ap.getPort();
            try {
                if (this.timeOut > 0) {
                    InetSocketAddress sockaddress = new InetSocketAddress(host, port);
                    this.peerConnection = new Socket();
                    ((Socket)this.peerConnection).connect(sockaddress, this.timeOut);
                } else {
                    this.peerConnection = new Socket(host, port);
                }
                this.inputStream = new BufferedInputStream(((Socket)this.peerConnection).getInputStream());
                this.outputStream = new BufferedOutputStream(((Socket)this.peerConnection).getOutputStream());
                this.available = true;
                continue;
            }
            catch (IOException e) {
                this.available = false;
                LogWriter.writeExceptionLog(e);
            }
        }
        return this.available;
    }

    @Override
    protected boolean sendNetworkName() {
        byte[] networkNameUTF8 = this.getNetworkUUID().getBytes(StandardCharsets.UTF_8);
        ByteBuffer intBuffer = ByteBuffer.allocate(4).putInt(networkNameUTF8.length);
        try {
            this.outputStream.write(intBuffer.array());
            this.outputStream.write(networkNameUTF8);
            this.outputStream.flush();
            return true;
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[ComboxSocket] Couldn't send network name");
            LogWriter.writeExceptionLog(e);
            return false;
        }
    }

    @Override
    protected boolean receiveNetworkName() {
        try {
            byte[] sizeBytes = new byte[4];
            this.inputStream.read(sizeBytes);
            int size = ByteBuffer.wrap(sizeBytes).getInt();
            byte[] networkNameBytes = new byte[size];
            this.inputStream.read(networkNameBytes);
            this.setNetworkUUID(new String(networkNameBytes, StandardCharsets.UTF_8));
            return true;
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[ComboxSocket] Couldn't read network name");
            LogWriter.writeExceptionLog(e);
            return false;
        }
    }

    @Override
    protected boolean exportConnectionInfo() {
        this.remoteCaller = new POPRemoteCaller(((Socket)this.peerConnection).getInetAddress(), MY_FACTORY.getComboxName(), this.getNetworkUUID(), MY_FACTORY.isSecure());
        return true;
    }
}

