/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox.socket.ssl;

import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.broker.RequestQueue;
import ch.icosys.popjava.core.combox.socket.ComboxAcceptSocket;
import ch.icosys.popjava.core.combox.socket.ssl.ComboxSecureSocket;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class ComboxAcceptSecureSocket
extends ComboxAcceptSocket<SSLSocket> {
    protected final SSLContext sslContext;

    public ComboxAcceptSecureSocket(Broker broker, RequestQueue requestQueue, ServerSocket serverSocket) throws IOException {
        super(broker, requestQueue, serverSocket);
        try {
            this.sslContext = SSLUtils.getSSLContext();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new IOException("Can't initialize SSL Context", e);
        }
    }

    @Override
    public void run() {
        SSLSocketFactory ssf = this.sslContext.getSocketFactory();
        while (this.status != 1) {
            try {
                ComboxSecureSocket combox;
                Socket plainConnection = this.serverSocket.accept();
                SSLSocket sslConnection = (SSLSocket)ssf.createSocket(plainConnection, plainConnection.getInputStream(), true);
                sslConnection.setUseClientMode(false);
                sslConnection.setNeedClientAuth(true);
                LogWriter.writeDebugInfo("[SSL Accept] Connection accepted " + sslConnection.getLocalPort() + " local:" + sslConnection.getPort());
                if (this.broker != null) {
                    this.broker.onNewConnection();
                }
                if (!(combox = new ComboxSecureSocket()).serverAccept(this.broker, sslConnection)) continue;
                ComboxAcceptSocket.serveConnection(this.broker, this.requestQueue, combox, 1);
                this.concurentConnections.add(sslConnection);
            }
            catch (IOException e) {
                LogWriter.writeDebugInfo("[SSL Accept] Error while setting up connection: %s", e.getMessage());
            }
        }
        LogWriter.writeDebugInfo("[SSL Accept] Combox Server finished");
        this.close();
    }
}

