/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox.socket.ssl;

import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.WatchDirectory;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;

public class POPKeyManager
implements X509KeyManager {
    private final Configuration conf = Configuration.getInstance();
    private X509KeyManager keyManager;
    private WatchDirectory keyStoreWatcher;

    public POPKeyManager() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        this.reloadKeyManager();
    }

    public final void reloadKeyManager() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        long start = System.currentTimeMillis();
        SSLUtils.invalidateSSLSessions();
        KeyStore keyStore = KeyStore.getInstance(this.conf.getSSLKeyStoreFormat().name());
        try (FileInputStream keyStoreStream = new FileInputStream(this.conf.getSSLKeyStoreFile());){
            keyStore.load(keyStoreStream, this.conf.getSSLKeyStorePassword().toCharArray());
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, this.conf.getSSLKeyStorePrivateKeyPassword().toCharArray());
        File keyStoreFile = this.conf.getSSLKeyStoreFile();
        if (keyStoreFile != null && keyStoreFile.canRead()) {
            Path keyStorePath = keyStoreFile.toPath().toAbsolutePath();
            boolean createWatcher = true;
            if (this.keyStoreWatcher != null) {
                if (keyStorePath.getParent().equals(this.keyStoreWatcher.getWatchedDir())) {
                    createWatcher = false;
                } else {
                    this.keyStoreWatcher.stop();
                }
            }
            if (createWatcher) {
                this.keyStoreWatcher = new WatchDirectory(keyStorePath.getParent(), new KeyStoreWatcher(keyStorePath), StandardWatchEventKinds.ENTRY_MODIFY);
                Thread keyWatcher = new Thread((Runnable)this.keyStoreWatcher, "KeyStore changes watcher (KeyManager)");
                keyWatcher.setDaemon(true);
                keyWatcher.start();
            }
        }
        long end = System.currentTimeMillis();
        LogWriter.writeDebugInfo(String.format("[KeyManager] initiated in %d ms", end - start));
        for (KeyManager itrKeyManager : keyManagerFactory.getKeyManagers()) {
            if (!(itrKeyManager instanceof X509KeyManager)) continue;
            this.keyManager = (X509KeyManager)itrKeyManager;
            return;
        }
        throw new NoSuchAlgorithmException("No X509KeyManager in KeyManagerFactory");
    }

    @Override
    public X509Certificate[] getCertificateChain(String alias) {
        return this.keyManager.getCertificateChain(alias);
    }

    @Override
    public PrivateKey getPrivateKey(String alias) {
        return this.keyManager.getPrivateKey(alias);
    }

    @Override
    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getClientAliases(keyType, issuers);
    }

    @Override
    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.keyManager.getServerAliases(keyType, issuers);
    }

    @Override
    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        return this.chooseSNIAlias(true, issuers, socket, keyType);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        return this.chooseSNIAlias(false, issuers, socket, keyTypes);
    }

    private String chooseSNIAlias(boolean server, Principal[] issuers, Socket socket, String ... keyTypes) {
        PrivateKey pk;
        if (!(socket instanceof SSLSocket)) {
            return null;
        }
        SSLSocket ssl = (SSLSocket)socket;
        ExtendedSSLSession handshakeSession = (ExtendedSSLSession)ssl.getHandshakeSession();
        if (handshakeSession == null) {
            return null;
        }
        String returns = null;
        for (SNIServerName sniNetwork : handshakeSession.getRequestedServerNames()) {
            if (sniNetwork.getType() != 0) continue;
            returns = ((SNIHostName)sniNetwork).getAsciiName();
            break;
        }
        if ((pk = this.keyManager.getPrivateKey(returns)) == null) {
            if (server) {
                return this.keyManager.chooseServerAlias(keyTypes[0], issuers, socket);
            }
            this.keyManager.chooseClientAlias(keyTypes, issuers, socket);
        }
        return returns == null ? null : returns.toLowerCase();
    }

    private class KeyStoreWatcher
    extends WatchDirectory.WatchMethod {
        private final Path keyStore;

        public KeyStoreWatcher(Path keyStore) {
            this.keyStore = keyStore;
        }

        @Override
        public void modify(String s) {
            if (this.keyStore.equals(this.keyStore.getParent().resolve(s))) {
                this.reload();
            }
        }

        private void reload() {
            try {
                POPKeyManager.this.reloadKeyManager();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

