/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.combox.socket.ssl;

import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.RuntimeDirectoryThread;
import ch.icosys.popjava.core.util.WatchDirectory;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class POPTrustManager
implements X509TrustManager {
    private final Configuration conf = Configuration.getInstance();
    private X509TrustManager trustManager;
    private final Map<String, Certificate> loadedCertificates = new HashMap<String, Certificate>();
    private final Set<String> confidenceCertificates = new HashSet<String>();
    private final Map<String, String> certificatesNetwork = new HashMap<String, String>();
    private final Map<String, Certificate> aliasCertificates = new HashMap<String, Certificate>();
    private WatchDirectory temporaryWatcher;
    private WatchDirectory keyStoreWatcher;

    public POPTrustManager() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        this.reloadTrustManager();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    public boolean isConfidenceLink(String fingerprint) {
        return this.confidenceCertificates.contains(fingerprint);
    }

    public String getNetworkFromFingerprint(String fingerprint) {
        return this.certificatesNetwork.get(fingerprint);
    }

    private void saveCertificatesToMemory() {
        X509Certificate[] certificates;
        HashMap<String, X509Certificate> temp = new HashMap<String, X509Certificate>();
        for (X509Certificate cert : certificates = this.getAcceptedIssuers()) {
            temp.put(SSLUtils.certificateFingerprint(cert), cert);
        }
        this.loadedCertificates.clear();
        this.loadedCertificates.putAll(temp);
    }

    public final void reloadTrustManager() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        TrustManager[] tms;
        File keyStoreFile;
        long start = System.currentTimeMillis();
        SSLUtils.invalidateSSLSessions();
        KeyStore trustedKS = KeyStore.getInstance(this.conf.getSSLKeyStoreFormat().name());
        try (FileInputStream trustedStore = new FileInputStream(this.conf.getSSLKeyStoreFile());){
            trustedKS.load(trustedStore, this.conf.getSSLKeyStorePassword().toCharArray());
        }
        this.confidenceCertificates.clear();
        Enumeration<String> certAlias = trustedKS.aliases();
        while (certAlias.hasMoreElements()) {
            File[] alias = certAlias.nextElement();
            Certificate cert = trustedKS.getCertificate((String)alias);
            String fingerprint = SSLUtils.certificateFingerprint(cert);
            this.confidenceCertificates.add(fingerprint);
            int atLocation = alias.indexOf(64);
            if (atLocation >= 0) {
                String network = alias.substring(atLocation + 1);
                this.certificatesNetwork.put(fingerprint, network);
            } else {
                this.certificatesNetwork.put(fingerprint, (String)alias);
            }
            this.aliasCertificates.put((String)alias, cert);
        }
        File tempCertDir = this.conf.getSSLTemporaryCertificateLocation();
        if (tempCertDir != null) {
            if (tempCertDir.exists()) {
                for (File file : tempCertDir.listFiles()) {
                    if (!file.isFile() || !file.getName().endsWith(".cer")) continue;
                    try {
                        Certificate cert = SSLUtils.certificateFromBytes(Files.readAllBytes(file.toPath()));
                        String alias = file.getName().substring(0, file.getName().length() - 4);
                        trustedKS.setCertificateEntry(alias, cert);
                    }
                    catch (Exception cert) {
                        // empty catch block
                    }
                }
            } else {
                RuntimeDirectoryThread rdt = new RuntimeDirectoryThread(tempCertDir);
                rdt.addCleanupHook();
            }
            if (tempCertDir.canRead()) {
                boolean createWatcher = true;
                if (this.temporaryWatcher != null) {
                    if (tempCertDir.toPath().equals(this.temporaryWatcher.getWatchedDir())) {
                        createWatcher = false;
                    } else {
                        this.temporaryWatcher.stop();
                    }
                }
                if (createWatcher) {
                    this.temporaryWatcher = new WatchDirectory(tempCertDir.toPath(), new TemporaryDirectoryWatcher(), StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                    Thread dirWatcher = new Thread((Runnable)this.temporaryWatcher, "TrustStore temporary folder watcher");
                    dirWatcher.setDaemon(true);
                    dirWatcher.start();
                }
            }
        }
        if ((keyStoreFile = this.conf.getSSLKeyStoreFile()) != null && keyStoreFile.canRead()) {
            Path keyStorePath = keyStoreFile.toPath().toAbsolutePath();
            boolean createWatcher = true;
            if (this.keyStoreWatcher != null) {
                if (keyStorePath.getParent().equals(this.keyStoreWatcher.getWatchedDir())) {
                    createWatcher = false;
                } else {
                    this.keyStoreWatcher.stop();
                }
            }
            if (createWatcher) {
                this.keyStoreWatcher = new WatchDirectory(keyStorePath.getParent(), new KeyStoreWatcher(keyStorePath), StandardWatchEventKinds.ENTRY_MODIFY);
                Thread keyWatcher = new Thread((Runnable)this.keyStoreWatcher, "KeyStore changes watcher (TrustManager)");
                keyWatcher.setDaemon(true);
                keyWatcher.start();
            }
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(trustedKS);
        long end = System.currentTimeMillis();
        LogWriter.writeDebugInfo(String.format("[TrustManager] initiated in %d ms", end - start));
        for (TrustManager tm : tms = tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            this.trustManager = (X509TrustManager)tm;
            this.saveCertificatesToMemory();
            return;
        }
        throw new NoSuchAlgorithmException("No X509TrustManager in TrustManagerFactory");
    }

    public boolean isCertificateKnown(Certificate cert) {
        return this.loadedCertificates.values().contains(cert);
    }

    public Certificate getCertificate(String fingerprint) {
        return this.loadedCertificates.get(fingerprint);
    }

    public Certificate getCertificateFromAlias(String uuid) {
        Objects.requireNonNull(uuid);
        return this.aliasCertificates.get(uuid.toLowerCase());
    }

    private class KeyStoreWatcher
    extends WatchDirectory.WatchMethod {
        private final Path keyStore;

        public KeyStoreWatcher(Path keyStore) {
            this.keyStore = keyStore;
        }

        @Override
        public void modify(String s) {
            if (this.keyStore.equals(this.keyStore.getParent().resolve(s))) {
                this.reload();
            }
        }

        private void reload() {
            try {
                POPTrustManager.this.reloadTrustManager();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class TemporaryDirectoryWatcher
    extends WatchDirectory.WatchMethod {
        private TemporaryDirectoryWatcher() {
        }

        @Override
        public void create(String file) {
            if (file.endsWith(".cer")) {
                this.reload();
            }
        }

        @Override
        public void delete(String file) {
            if (file.endsWith(".cer")) {
                this.reload();
            }
        }

        private void reload() {
            try {
                POPTrustManager.this.reloadTrustManager();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

