/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.javaagent;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.annotation.POPClass;
import ch.icosys.popjava.core.base.POPObject;
import ch.icosys.popjava.core.system.POPSystem;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.expr.ExprEditor;
import javassist.expr.FieldAccess;
import javassist.expr.NewExpr;
import javassist.util.proxy.ProxyObject;

public final class POPJavaAgent
implements ClassFileTransformer {
    private static final String POP_JAVA_BASE = POPObject.class.getName();
    private final ClassPool classPool;
    private final Set<String> IGNORED = new HashSet<String>();
    private static POPJavaAgent me;

    private POPJavaAgent(Instrumentation instrumentation) {
        this.classPool = ClassPool.getDefault();
        instrumentation.addTransformer(this);
        try {
            this.classPool.appendPathList(System.getProperty("java.class.path"));
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        this.IGNORED.add("popjava.");
        this.IGNORED.add("com.sun.");
        this.IGNORED.add("sun.");
        this.IGNORED.add("javassist.");
        this.IGNORED.add("java.");
        this.IGNORED.add("javax.");
        this.IGNORED.add("org.w3c.");
        this.IGNORED.add("org.xml.");
        this.IGNORED.add("org.netbeans.");
    }

    public static POPJavaAgent getInstance() {
        if (me == null) {
            throw new UnsupportedOperationException("Java was not started with the -javaagent parameter");
        }
        return me;
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        me = new POPJavaAgent(inst);
    }

    private boolean isInIgnoredPackage(String className) {
        for (String packageName : this.IGNORED) {
            if (!className.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    private boolean isProxy(CtClass rawClass) {
        try {
            CtClass parent = rawClass.getSuperclass();
            if (parent != null) {
                for (CtClass inter : rawClass.getInterfaces()) {
                    if (!inter.getName().equals(ProxyObject.class.getName())) continue;
                    return true;
                }
                return this.isProxy(parent);
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJar(String file) throws NotFoundException {
        ClassPool classPool = this.classPool;
        synchronized (classPool) {
            this.classPool.appendClassPath(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        if (this.classPool == null) {
            return null;
        }
        String dotClassName = className.replace('/', '.');
        if (this.isInIgnoredPackage(dotClassName)) {
            return null;
        }
        try {
            ClassPool classPool = this.classPool;
            synchronized (classPool) {
                this.classPool.insertClassPath((ClassPath)new ByteArrayClassPath(dotClassName, classfileBuffer));
            }
            CtClass rawClass = this.classPool.get(dotClassName);
            if (!rawClass.isFrozen() && this.isPOPClass(rawClass) && !this.isProxy(rawClass)) {
                boolean isDistributable;
                POPClass popClass = (POPClass)rawClass.getAnnotation(POPClass.class);
                boolean bl = isDistributable = popClass == null || popClass.isDistributable();
                if (this.classNeedsSuperclass(rawClass)) {
                    if (isDistributable && rawClass.getSuperclass() != null && !rawClass.getSuperclass().getName().equals(Object.class.getName()) && !rawClass.getSuperclass().getName().equals(POPObject.class.getName())) {
                        throw new RuntimeException(rawClass.getName() + " has non POPClass superclass " + rawClass.getSuperclass().getName());
                    }
                    if (isDistributable && (rawClass.getSuperclass() == null || !rawClass.getSuperclass().getName().equals(POPObject.class.getName()))) {
                        CtClass superClass = this.classPool.get(POP_JAVA_BASE);
                        rawClass.setSuperclass(superClass);
                    }
                }
                if (!this.hasDefaultConstructor(rawClass)) {
                    // empty if block
                }
                HashSet<CtMethod> methods = new HashSet<CtMethod>();
                for (CtMethod method : rawClass.getDeclaredMethods()) {
                    methods.add(method);
                }
                for (CtMethod method : rawClass.getMethods()) {
                    methods.add(method);
                }
                for (CtMethod method : methods) {
                    String longMethodName;
                    if (method.getName().equals("main") && Modifier.isStatic((int)method.getModifiers())) {
                        method.insertBefore("$1 = " + POPSystem.class.getName() + ".initialize($1);");
                        method.insertAfter(POPSystem.class.getName() + ".end();", true);
                    }
                    if (!(longMethodName = method.getLongName()).startsWith(dotClassName) || longMethodName.contains("access$")) continue;
                    this.instrumentCode(loader, (CtBehavior)method);
                    this.checkMethodParameters(method);
                }
                for (CtConstructor constructor : rawClass.getConstructors()) {
                    this.instrumentCode(loader, (CtBehavior)constructor);
                }
                return rawClass.toBytecode();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.out.println(ioe.getMessage() + " transforming class " + className + "; returning default class: 1");
        }
        catch (NotFoundException nfe) {
            nfe.printStackTrace();
            System.out.println(nfe.getMessage() + " transforming class " + className + "; returning default class: 2 SIZE: " + classfileBuffer.length);
        }
        catch (CannotCompileException cce) {
            cce.printStackTrace();
            System.out.println(cce.getMessage() + " transforming class " + className + "; returning default class: 3");
        }
        catch (Exception e) {
            System.out.println("An error occurred during " + className + " class transformation: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    private void checkMethodParameters(CtMethod method) throws ClassNotFoundException, CannotCompileException {
        try {
            for (CtClass parameter : method.getParameterTypes()) {
                POPClass popClass = (POPClass)parameter.getAnnotation(POPClass.class);
                if (popClass == null || popClass.isDistributable()) continue;
                throw new CannotCompileException("Can not pass " + parameter.getName() + " as parameter to " + method.getLongName());
            }
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
    }

    private void instrumentCode(ClassLoader loader, final CtBehavior method) throws CannotCompileException {
        ExprEditor ed = new ExprEditor(){

            public void edit(NewExpr e) throws CannotCompileException {
                try {
                    if (POPJavaAgent.this.isInIgnoredPackage(e.getClassName())) {
                        return;
                    }
                    CtClass clazz = e.getConstructor().getDeclaringClass();
                    if (POPJavaAgent.this.isPOPClass(clazz) && POPJavaAgent.this.isDistributable(clazz)) {
                        int isStatic = e.where().getModifiers() & 8;
                        String me = "this";
                        if (isStatic > 0) {
                            me = "null";
                        }
                        String newCall = "$_ = ($r)" + PopJava.class.getName() + ".newActive(" + me + ", " + clazz.getName() + ".class, $args);";
                        e.replace(newCall);
                    }
                }
                catch (NotFoundException e1) {
                    e1.printStackTrace();
                }
            }

            public void edit(FieldAccess f) throws CannotCompileException {
                if (f.isWriter()) {
                    if (POPJavaAgent.this.isInIgnoredPackage(f.getClassName())) {
                        return;
                    }
                    CtClass clazz = null;
                    try {
                        clazz = f.getField().getType();
                        if (POPJavaAgent.this.isPOPClass(clazz)) {
                            String newAssign = "if ($1 == null) $0." + f.getFieldName() + " = $1; else ";
                            String baseStart = "$0." + f.getFieldName() + " = ";
                            String baseEnd = "(" + clazz.getName() + ") ((" + POPObject.class.getName() + ")$1).makePermanent();";
                            if (clazz.equals(method.getDeclaringClass())) {
                                String potentialThisAssign = "$1 == this ? (" + clazz.getName() + ")getThis(" + clazz.getName() + ".class): ";
                                newAssign = newAssign + baseStart + potentialThisAssign + baseEnd;
                            } else {
                                newAssign = newAssign + baseStart + baseEnd;
                            }
                            f.replace(newAssign);
                        }
                    }
                    catch (NotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        method.instrument(ed);
    }

    private boolean isPOPClass(CtClass rawClass) {
        try {
            Object popClass = rawClass.getAnnotation(POPClass.class);
            if (popClass != null) {
                return true;
            }
            CtClass superClass = rawClass.getSuperclass();
            if (superClass != null) {
                return this.isPOPClass(superClass);
            }
        }
        catch (ClassNotFoundException | NotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean isDistributable(CtClass rawClass) {
        try {
            Object popClass = rawClass.getAnnotation(POPClass.class);
            if (popClass != null) {
                return ((POPClass)popClass).isDistributable();
            }
            CtClass superClass = rawClass.getSuperclass();
            if (superClass != null) {
                return this.isPOPClass(superClass);
            }
        }
        catch (ClassNotFoundException | NotFoundException e) {
            e.printStackTrace();
        }
        return false;
    }

    private boolean classNeedsSuperclass(CtClass rawClass) {
        try {
            CtClass superClass = rawClass.getSuperclass();
            if (superClass == null) {
                return false;
            }
            boolean parentIsPOPObject = this.isPOPClass(superClass);
            return !parentIsPOPObject;
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean hasDefaultConstructor(CtClass rawClass) throws NotFoundException {
        boolean hasDefaultConstructor = false;
        for (CtConstructor constructor : rawClass.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            hasDefaultConstructor = true;
        }
        return hasDefaultConstructor;
    }
}

