/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.scripts;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.annotation.POPClass;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.service.jobmanager.POPJavaJobManager;
import ch.icosys.popjava.core.util.Configuration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

@POPClass(isDistributable=false)
public class PopjServices {
    public static void main(String[] args) throws InterruptedException {
        Configuration conf = Configuration.getInstance();
        Integer port = null;
        String config = conf.getSystemJobManagerConfig().getAbsolutePath();
        ArrayList<String> argl = new ArrayList<String>(Arrays.asList(args));
        Iterator itr = argl.iterator();
        while (itr.hasNext()) {
            String token;
            switch (token = (String)itr.next()) {
                case "-h": 
                case "--help": {
                    System.err.println("usage: PopjServices [-p|--port <port num>] [-c|--config <jm config file>]");
                    System.exit(1);
                    break;
                }
                case "-p": 
                case "--port": {
                    String portString = (String)itr.next();
                    try {
                        port = Integer.parseInt(portString);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "-c": 
                case "--config": {
                    config = (String)itr.next();
                }
            }
        }
        try {
            POPJavaJobManager jm;
            if (port != null) {
                jm = PopJava.newActive(null, POPJavaJobManager.class, "localhost:" + port, config);
            } else {
                String[] protocols = conf.getJobManagerProtocols();
                int[] ports = conf.getJobManagerPorts();
                for (int i = 0; i < protocols.length; ++i) {
                    protocols[i] = protocols[i] + ":" + ports[i];
                }
                jm = PopJava.newActive(null, POPJavaJobManager.class, "localhost", protocols);
            }
            POPAccessPoint jm_ap = PopJava.getAccessPoint(jm);
            System.out.println("[JM] " + jm_ap.toString());
            jm.start();
            jm.stayAlive();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

