/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.scripts;

import ch.icosys.popjava.core.scripts.ScriptUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Popjavac {
    private static final String POPJAVA_FOLDER;
    private static final String JAVAC;
    private static final String JAR_FOLDER = "JarFile";
    public static final String POP_JAVA_JAR_FILE = "popjava.jar";
    private static final String COMPILER_JAR;
    private static final String POPJAVA_JAR;
    private static final String COMPILER_MAIN = "POPJParser";
    private static boolean verbose;
    private static boolean noclean;
    private static boolean onlyTranslate;
    private static boolean onlyClean;
    private static final String HELP_MESSAGE = "POP-Java Compiler v1.0\n\nThis program is used to compile a POP-Java program\n\nUsage: popjc <options> <source files>\n\nOPTIONS:\n   -h, --help               Show this message\n   -n, --noclean            Do not clean the intermediate Java file generated by the POP-Java parser\n   -l, --clean              Only clean the generated Java files, perform no other task \n   -t, --translate          Only translate the pjava files into java, do not compile them\n   -p, --popcpp <xml_file>  Compile a POP-Java parallel class for POP-C++ usage (Need XML additional informations file)\n   -j, --jar <filename>     Create a JAR archive with the given name (Need the JAR file name)\n   -v, --verbose            Verbose mode\n   -c, --classpath <files>  Include JAR or compiled Java class to the compilation process. Files must be separated by a semicolon \":\"\n\nOPTIONS FOR POP-C++ INTEROPERABILITY:\n   -x, --xmlpopcpp <files>  Generate a canvas of the POP-C++ XML additional informations file for the given Java files. This option must be used alone\n   -g, --generate <pjava>   Generate the POP-C++ partial implementation to use the given POP-Java parclass in a POP-C++ application (NOT IMPLEMENTED YET)\n";

    private static void printHelp() {
        System.out.println(HELP_MESSAGE);
    }

    public static void main(String[] args) {
        Popjavac.main2(new String[]{"-x", "/home/asraniel/workspace/POPJavaFuture/example/mixed1/Integer.java"});
    }

    public static void main2(String[] args) {
        for (String arg : args) {
            System.out.println(arg);
        }
        if (args.length == 0 || ScriptUtils.containsOption(args, "-h") || ScriptUtils.containsOption(args, "--help")) {
            Popjavac.printHelp();
            return;
        }
        List<String> arguments = ScriptUtils.arrayToList(args);
        String jar = ScriptUtils.getOption(arguments, "", false, "-j", "--jar");
        String popcInfo = ScriptUtils.getOption(arguments, "", false, "-p", "--popcpp");
        String classPath = ScriptUtils.getOption(arguments, "", false, "-c", "--classpath");
        String generate = ScriptUtils.getOption(arguments, "", true, "-x", "--xmlpopcpp");
        verbose = ScriptUtils.removeOption(arguments, "-v", "--verbose");
        onlyTranslate = ScriptUtils.removeOption(arguments, "-t", "--translate");
        onlyClean = ScriptUtils.removeOption(arguments, "-l", "--clean");
        noclean = ScriptUtils.removeOption(arguments, "-n", "--noclean") | onlyTranslate;
        System.out.println("Files to compile:");
        if (arguments.size() != 1 || new File(arguments.get(0)).isDirectory()) {
            // empty if block
        }
        for (String string : arguments) {
            System.out.println(string);
        }
        if (!generate.isEmpty()) {
            try {
                Popjavac.generateXML("additional-infos.xml", arguments);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        List<String> binaries = Popjavac.extractBinaries(arguments);
        for (String file : binaries) {
            if (classPath.isEmpty()) {
                classPath = classPath + File.pathSeparatorChar;
            }
            classPath = classPath + file;
        }
        List<String> list = Popjavac.processFiles(arguments, classPath, popcInfo);
        if (!jar.isEmpty()) {
            Popjavac.jarFiles(jar, list);
        }
    }

    private static void generateXML(String xml, List<String> files) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(xml));
        writer.write("<popjparser-infos>" + ScriptUtils.getNewline());
        for (String file : files) {
            writer.write("\t<popc-parclass file=\"" + file + "\" name=\"\" classuid=\"\" hasDestructor=\"true\"/>" + ScriptUtils.getNewline());
        }
        writer.write("</popjparser-infos>");
        writer.close();
    }

    private static List<String> extractBinaries(List<String> files) {
        ArrayList<String> binaries = new ArrayList<String>();
        for (int i = 0; i < files.size(); ++i) {
            String file = files.get(i);
            if (!file.endsWith(".jar") && !file.endsWith(".class")) continue;
            binaries.add(file);
            files.remove(i);
            --i;
        }
        return binaries;
    }

    private static List<String> expandSources(List<String> sourceFiles) {
        ArrayList<String> sources = new ArrayList<String>();
        try {
            for (String path : sourceFiles) {
                File temp = new File(path);
                String name = temp.getName();
                Path parent = new File("").toPath();
                if (temp.getParentFile() != null) {
                    parent = temp.getParentFile().toPath();
                }
                DirectoryStream<Path> stream = Files.newDirectoryStream(parent, name);
                for (Path source : stream) {
                    String file = source.toFile().getPath();
                    if (!new File(file).exists()) {
                        System.err.println("File " + file + " does not exist, aborting compilation");
                    }
                    sources.add(file);
                }
                stream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sources;
    }

    private static List<String> processFiles(List<String> sourceParameter, String classPath, String popcInfo) {
        List<String> sourceFiles = Popjavac.expandSources(sourceParameter);
        String sources = "";
        for (int i = 0; i < sourceFiles.size(); ++i) {
            String file = sourceFiles.get(i);
            if (Popjavac.isMain(file) || !file.endsWith(".pjava")) continue;
            sources = sources + file;
            if (i == sourceFiles.size() - 1) continue;
            sources = sources + File.pathSeparatorChar;
        }
        if (sources.length() > 0) {
            while (sources.charAt(sources.length() - 1) == File.pathSeparatorChar) {
                sources = sources.substring(0, sources.length() - 1);
            }
        }
        ArrayList<String> javaFiles = new ArrayList<String>();
        ArrayList<String> convertedFiles = new ArrayList<String>();
        for (String file : sourceFiles) {
            if (file.endsWith(".java")) {
                javaFiles.add(file);
                continue;
            }
            String javaFile = file.replace(".pjava", ".java");
            convertedFiles.add(javaFile);
            Popjavac.convertFile(file, javaFile, sources, popcInfo);
        }
        ArrayList<String> allFiles = new ArrayList<String>(javaFiles);
        allFiles.addAll(convertedFiles);
        List<String> classFiles = Collections.emptyList();
        if (!onlyTranslate && !onlyClean) {
            classFiles = Popjavac.compileFiles(allFiles, classPath);
        }
        if (!noclean) {
            for (String file : convertedFiles) {
                new File(file).delete();
            }
        }
        return classFiles;
    }

    private static boolean grep(File file, String search) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(file));
        while ((line = reader.readLine()) != null) {
            if (!line.contains(search)) continue;
            reader.close();
            return true;
        }
        reader.close();
        return false;
    }

    private static boolean isMain(String input) {
        try {
            return Popjavac.grep(new File(input), "public static void main");
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void convertFile(String input, String output, String sources, String popcInfos) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("java");
        parameters.add("-cp");
        parameters.add(COMPILER_JAR);
        parameters.add(COMPILER_MAIN);
        if (Popjavac.isMain(input)) {
            parameters.add("-m");
        }
        parameters.add("-file=" + input);
        if (popcInfos != null && !popcInfos.isEmpty()) {
            parameters.add("-popcinfos=" + popcInfos);
        }
        parameters.add("-parclasses=" + sources);
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(new File(output)));
            if (ScriptUtils.runNativeApplication(ScriptUtils.listToArray(parameters), "Could not find java executable in path", writer, verbose) != 0) {
                System.err.println("Error while compiling " + input);
                System.exit(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static List<String> compileFiles(List<String> javaFiles, String classPathElements) {
        ArrayList<String> outputFiles = new ArrayList<String>();
        System.out.println("Compile java files: " + javaFiles.size() + " files");
        String[] command = new String[3 + javaFiles.size()];
        command[0] = JAVAC;
        command[1] = "-cp";
        command[2] = POPJAVA_JAR + File.pathSeparatorChar + classPathElements;
        int index = 3;
        for (String file : javaFiles) {
            command[index++] = file;
            outputFiles.add(file.replace(".java", ".class"));
        }
        ScriptUtils.runNativeApplication(command, "javac is not installed, please install the java jdk (not jre) or add it to the PATH", null, verbose);
        return outputFiles;
    }

    private static void jarFiles(String jar, List<String> classFiles) {
        String[] command = new String[3 + classFiles.size()];
        command[0] = "jar";
        command[1] = "cf";
        command[2] = jar;
        int index = 3;
        for (String file : classFiles) {
            command[index++] = file;
        }
        ScriptUtils.runNativeApplication(command, "The jar command could not be found", null, verbose);
        for (String file : classFiles) {
            new File(file).delete();
        }
    }

    static {
        String popJavaLocation = System.getenv("POPJAVA_LOCATION");
        POPJAVA_FOLDER = popJavaLocation == null || popJavaLocation.isEmpty() ? (ScriptUtils.isWindows() ? "C:\\Users\\asraniel\\workspace\\PopJava\\release\\" : "/usr/local/popj/") : popJavaLocation + File.separatorChar;
        String executable = "javac";
        try {
            Process p = Runtime.getRuntime().exec(executable);
            if (p.waitFor() != 0) {
                executable = null;
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
        if (executable == null) {
            executable = ScriptUtils.isWindows() ? "C:\\Program Files\\Java\\jdk1.7.0_11\\bin\\javac" : "javac";
        }
        JAVAC = executable;
        COMPILER_JAR = POPJAVA_FOLDER + JAR_FOLDER + File.separatorChar + "popjparser.jar";
        POPJAVA_JAR = POPJAVA_FOLDER + JAR_FOLDER + File.separatorChar + POP_JAVA_JAR_FILE;
        verbose = false;
        noclean = false;
        onlyTranslate = false;
        onlyClean = false;
    }
}

