/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.scripts.shell;

import ch.icosys.popjava.core.scripts.shell.Parameter;
import ch.icosys.popjava.core.scripts.shell.ParameterInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Scanner;

public class CommandInfo {
    private final String keyword;
    private final String[] params;

    public CommandInfo(String line) {
        Scanner s = new Scanner(line);
        this.keyword = s.next();
        ArrayList<String> args = new ArrayList<String>();
        String arg = "";
        char quote = '\u0000';
        while (s.hasNext()) {
            arg = arg + s.next();
            char start = arg.charAt(0);
            char end = arg.charAt(arg.length() - 1);
            if (start == '\"' || start == '\'') {
                quote = start;
                arg = arg.substring(1);
                continue;
            }
            if (end == quote) {
                arg = arg.substring(0, arg.length() - 1);
                args.add(arg);
                arg = "";
                continue;
            }
            args.add(arg);
            arg = "";
        }
        this.params = args.toArray(new String[arg.length()]);
        s.close();
    }

    private CommandInfo(String keyword, String ... params) {
        this.keyword = keyword;
        this.params = params;
    }

    public Parameter extractParameter(ParameterInfo ... expected) {
        return new Parameter(this.params, expected);
    }

    public CommandInfo advance() {
        if (!this.canAdvance()) {
            return null;
        }
        return new CommandInfo(this.params[0], Arrays.copyOfRange(this.params, 1, this.params.length));
    }

    public boolean canAdvance() {
        return this.params.length > 0;
    }

    public boolean isNextHelp() {
        return this.canAdvance() && (this.params[0].equals("-h") || this.params[0].equals("--help"));
    }

    public String getKeyword() {
        return this.keyword;
    }

    public String[] getParams() {
        return Arrays.copyOf(this.params, this.params.length);
    }
}

