/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.scripts.shell;

import ch.icosys.popjava.core.scripts.shell.CommandInfo;
import java.io.Console;
import java.util.Scanner;

public class ConsoleHandler {
    private final Scanner scanner = new Scanner(System.in);
    private final Console console = System.console();
    private final boolean hasConsole = this.console != null;
    private static ConsoleHandler instance;

    public static ConsoleHandler getInstance() {
        if (instance == null) {
            instance = new ConsoleHandler();
        }
        return instance;
    }

    private ConsoleHandler() {
    }

    public CommandInfo readCommand() {
        String line = this.readLine();
        return line == null ? null : new CommandInfo(line);
    }

    public String readPassword() {
        if (this.hasConsole) {
            return new String(this.console.readPassword());
        }
        return this.scanner.nextLine();
    }

    public String readLine() {
        String line = this.hasConsole ? this.console.readLine() : this.scanner.nextLine();
        return line == null || line.trim().isEmpty() ? null : line;
    }
}

