/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.scripts.shell;

import ch.icosys.popjava.core.scripts.shell.ConsoleHandler;
import ch.icosys.popjava.core.scripts.shell.ParameterInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Parameter {
    private final Map<String, ParameterInfo> raw = new HashMap<String, ParameterInfo>();
    private final Map<String, String> params = new HashMap<String, String>();
    private final List<String> endArgs = new ArrayList<String>();

    public Parameter(String[] params, ParameterInfo ... expected) {
        List<String> lp = Arrays.asList(params);
        for (ParameterInfo pi : expected) {
            this.raw.put(pi.getAlias(), pi);
        }
        Iterator<String> itr = lp.iterator();
        while (itr.hasNext()) {
            String key = itr.next();
            for (ParameterInfo pi : expected) {
                if (pi.keyMatch(key)) {
                    if (!pi.hasArgument()) {
                        this.params.put(pi.getAlias(), "");
                        continue;
                    }
                    if (itr.hasNext()) {
                        this.params.put(pi.getAlias(), itr.next());
                        continue;
                    }
                    throw new IllegalArgumentException(key + " require an argument");
                }
                this.endArgs.add(key);
            }
        }
    }

    public String get(String param, Object returnOnNull) {
        ParameterInfo pi = this.raw.get(param);
        if (pi == null && returnOnNull != null) {
            return returnOnNull.toString();
        }
        String r = this.params.get(param);
        if (r == null && returnOnNull != null) {
            r = returnOnNull.toString();
        }
        return r;
    }

    public String get(String param) {
        ParameterInfo pi = this.raw.get(param);
        if (pi == null) {
            return null;
        }
        String out = this.params.get(param);
        if (out == null && pi.hasArgument()) {
            ConsoleHandler ch = ConsoleHandler.getInstance();
            System.out.format("missing value for '%s': ", pi.getAlias());
            out = pi.isMasked() ? ch.readPassword() : ch.readLine();
        }
        return out;
    }

    public List<String> getEndArgs() {
        return Collections.unmodifiableList(this.endArgs);
    }
}

