/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.scripts.shell.command;

import ch.icosys.popjava.core.JobManagerConfig;
import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.combox.ComboxFactory;
import ch.icosys.popjava.core.combox.ComboxFactoryFinder;
import ch.icosys.popjava.core.dataswaper.POPString;
import ch.icosys.popjava.core.scripts.POPJShell;
import ch.icosys.popjava.core.scripts.shell.CommandHandler;
import ch.icosys.popjava.core.scripts.shell.CommandInfo;
import ch.icosys.popjava.core.scripts.shell.ICommand;
import ch.icosys.popjava.core.scripts.shell.Parameter;
import ch.icosys.popjava.core.scripts.shell.ParameterInfo;
import ch.icosys.popjava.core.service.jobmanager.POPJavaJobManager;
import ch.icosys.popjava.core.service.jobmanager.external.POPNetworkDetails;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptorFinder;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.List;

public class CJobManager
implements ICommand {
    private final CommandHandler commandHandler = new CommandHandler();
    private POPJavaJobManager jobManager = null;
    private JobManagerConfig jobManagerConfig = null;

    public CJobManager() {
        this.initCommands();
    }

    private void initCommands() {
        this.commandHandler.add(new Start());
        this.commandHandler.add(new Stop());
        this.commandHandler.add(new Network());
        this.commandHandler.add(new Node());
    }

    @Override
    public String keyword() {
        return "jm";
    }

    @Override
    public int execute(CommandInfo info) {
        if (info.canAdvance()) {
            return this.commandHandler.execute(info.advance());
        }
        System.out.println(this.help());
        return 1;
    }

    @Override
    public String help() {
        return this.commandHandler.help();
    }

    @Override
    public String description() {
        return "configuration of the local job manager";
    }

    private boolean isJobManagerRunning() {
        try {
            this.jobManager.query("power", new POPString());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private JobManagerConfig getJobManagerConfig() {
        if (this.jobManagerConfig == null) {
            this.jobManagerConfig = new JobManagerConfig();
        }
        return this.jobManagerConfig;
    }

    private class NodeList
    implements ICommand {
        @Override
        public String keyword() {
            return "list";
        }

        @Override
        public int execute(CommandInfo info) {
            POPNode[] nodes;
            if (!CJobManager.this.isJobManagerRunning()) {
                System.err.println("The Job Manager is not running");
                return 1;
            }
            Parameter params = info.extractParameter(new ParameterInfo("uuid", "--uuid", "-u"));
            JobManagerConfig jmc = CJobManager.this.getJobManagerConfig();
            String uuid = params.get("uuid", null);
            if (uuid == null && info.canAdvance()) {
                uuid = info.getParams()[0];
            } else if (uuid == null) {
                CJobManager.this.commandHandler.execute(new CommandInfo("network list"));
                uuid = params.get("uuid");
            }
            for (POPNode node : nodes = jmc.networkNodes(uuid)) {
                System.out.println(node.getConnectorDescriptor().getGlobalName() + " @ " + node);
            }
            return 0;
        }

        @Override
        public String help() {
            return "usage: jm node list\n" + this.description();
        }

        @Override
        public String description() {
            return "list all nodes in a network";
        }
    }

    private class NodeRemove
    implements ICommand {
        @Override
        public String keyword() {
            return "remove";
        }

        @Override
        public int execute(CommandInfo info) {
            boolean hasNetwork;
            if (!CJobManager.this.isJobManagerRunning()) {
                System.err.println("The Job Manager is not running");
                return 1;
            }
            Parameter params = info.extractParameter(new ParameterInfo("uuid", "--uuid", "-u"), new ParameterInfo("id", "--id", "-I"));
            String uuid = params.get("uuid");
            List<POPNetworkDetails> networks = Arrays.asList(CJobManager.this.jobManager.getAvailableNetworks());
            boolean bl = hasNetwork = networks.stream().filter(d -> d.getUUID().equalsIgnoreCase(uuid)).count() == 1L;
            if (!hasNetwork) {
                System.err.format("Can't find network with id '%s'", uuid);
                System.err.println("Available IDs:");
                for (POPNetworkDetails network : networks) {
                    System.err.println("  " + network.getUUID());
                }
                return 3;
            }
            JobManagerConfig jmc = CJobManager.this.getJobManagerConfig();
            POPNode[] nodes = jmc.networkNodes(uuid);
            String sid = params.get("id", null);
            if (sid == null || sid.isEmpty()) {
                System.out.println("Choose a node:");
                for (int i = 0; i < nodes.length; ++i) {
                    System.out.format(" [%d] %s\n", i, nodes[i].toString());
                }
                sid = params.get("id");
            }
            try {
                int id = Integer.parseInt(sid);
                if (id >= nodes.length || id < 0) {
                    System.err.println("Given ID is not valid.");
                    return 4;
                }
                POPNode node = nodes[id];
                jmc.unregisterNode(uuid, node);
                System.out.println("Node removed.");
            }
            catch (NumberFormatException e) {
                System.out.println("Given ID is not a number.");
                return 5;
            }
            return 0;
        }

        @Override
        public String help() {
            return "usage: jm node remove [OPTIONS]\n" + this.description() + "\nAvailable options:\n  --uuid, -u          The UUID of the network\n  --id, -I            The id of the node\n";
        }

        @Override
        public String description() {
            return "remove a node from a network";
        }
    }

    private class NodeAdd
    implements ICommand {
        @Override
        public String keyword() {
            return "add";
        }

        @Override
        public int execute(CommandInfo info) {
            boolean hasNetwork;
            if (!CJobManager.this.isJobManagerRunning()) {
                System.err.println("The Job Manager is not running");
                return 1;
            }
            Parameter params = info.extractParameter(new ParameterInfo("type", "--type", "-t"), new ParameterInfo("uuid", "--uuid", "-u"), new ParameterInfo("host", "--host", "-H"), new ParameterInfo("port", "--port", "-p"), new ParameterInfo("protocol", "--protocol", "-P"), new ParameterInfo("certificate", "--certificate", "-c"), new ParameterInfo("secret", "--secret", "-s"));
            String type = params.get("type");
            String uuid = params.get("uuid");
            POPNetworkDescriptor descriptor = POPNetworkDescriptor.from(type);
            if (descriptor == null) {
                System.err.format("unknown node for type '%s'.\n", type);
                System.err.format("Available descriptors: %s\n", Arrays.toString(POPNetworkDescriptorFinder.getInstance().all()));
                return 2;
            }
            List<POPNetworkDetails> networks = Arrays.asList(CJobManager.this.jobManager.getAvailableNetworks());
            boolean bl = hasNetwork = networks.stream().filter(d -> d.getUUID().equalsIgnoreCase(uuid)).count() == 1L;
            if (!hasNetwork) {
                System.err.format("Can't find network with id '%s'", uuid);
                System.err.println("Available IDs:");
                for (POPNetworkDetails network : networks) {
                    System.err.println("  " + network.getUUID());
                }
                return 3;
            }
            String host = params.get("host");
            String port = params.get("port");
            switch (descriptor.getGlobalName()) {
                case "jobmanager": 
                case "tfc": {
                    String protocol = params.get("protocol");
                    String certificate = params.get("certificate");
                    ComboxFactory factory = ComboxFactoryFinder.getInstance().findFactory(protocol);
                    if (factory == null) {
                        System.err.format("protocol '%s' not found, node not added\n", protocol);
                        return 4;
                    }
                    if (!factory.isAvailable()) {
                        System.out.println("Warning: this factory seems not to be available or disabled.");
                    }
                    Certificate cert = null;
                    if (certificate != null && !certificate.isEmpty()) {
                        try {
                            byte[] bytes = Files.readAllBytes(Paths.get(certificate, new String[0]));
                            cert = SSLUtils.certificateFromBytes(bytes);
                        }
                        catch (IOException ex) {
                            System.err.println("Can't read certificate.");
                            return 5;
                        }
                        catch (CertificateException ex) {
                            System.err.println("Given file doesn't seems to be a X.501 certificate.");
                            return 6;
                        }
                    }
                    String[] nodeParams = new String[]{"host=" + host, "port=" + port, "protocol=" + protocol};
                    POPNode node = descriptor.createNode(Arrays.asList(nodeParams));
                    JobManagerConfig jmc = CJobManager.this.getJobManagerConfig();
                    if (cert == null) {
                        jmc.registerNode(uuid, node);
                    } else {
                        jmc.registerNode(uuid, node, cert);
                    }
                    System.out.format("Node added to network '%s'\n", uuid);
                    return 0;
                }
                case "direct": {
                    String protocol = params.get("protocol");
                    if (protocol == null || protocol.isEmpty()) {
                        protocol = "ssh";
                    }
                    return 0;
                }
            }
            return 1;
        }

        @Override
        public String help() {
            return "usage: jm node add [OPTIONS]\n" + this.description() + "\nAvailable options:\n  --type, -t          The type of node we are working with (jobmanager, tfc, direct)\n  --uuid, -u          The UUID of the network to add the node into\n  --host, -H          The destination host of the node\n  --port, -p          The destination port of the node\n  --protocol, -P      The node specific protocol (socket, ssl, daemon)\n  --certificate, -c   The certificate for the SSL connection\nNode specific options will be asked if missing.";
        }

        @Override
        public String description() {
            return "add a new node to a network";
        }
    }

    private class Node
    implements ICommand {
        private final CommandHandler commandNodeHandler = new CommandHandler();

        public Node() {
            this.initNodeCommands();
        }

        private void initNodeCommands() {
            this.commandNodeHandler.add(new NodeAdd());
            this.commandNodeHandler.add(new NodeRemove());
            this.commandNodeHandler.add(new NodeList());
        }

        @Override
        public String keyword() {
            return "node";
        }

        @Override
        public int execute(CommandInfo info) {
            if (info.canAdvance()) {
                return this.commandNodeHandler.execute(info.advance());
            }
            System.out.println(this.help());
            return 1;
        }

        @Override
        public String help() {
            return this.commandNodeHandler.help();
        }

        @Override
        public String description() {
            return "operation on the job manager nodes";
        }
    }

    private class NetworkList
    implements ICommand {
        @Override
        public String keyword() {
            return "list";
        }

        @Override
        public int execute(CommandInfo info) {
            POPNetworkDetails[] networks;
            if (!CJobManager.this.isJobManagerRunning()) {
                System.err.println("The Job Manager is not running");
                return 1;
            }
            JobManagerConfig jmc = CJobManager.this.getJobManagerConfig();
            System.out.println("Note that networks are identified by their UUID.");
            System.out.println("+------------------------------------------+--------------------------------+");
            System.out.println("| UUID                                     | Friendly name                  |");
            System.out.println("+==========================================+================================+");
            for (POPNetworkDetails network : networks = jmc.availableNetworks()) {
                System.out.format("| %-40s | %-30s |\n", network.getUUID(), network.getFriendlyName());
                System.out.println("+------------------------------------------+--------------------------------+");
            }
            return 0;
        }

        @Override
        public String help() {
            return "usage: jm netowrk list\n" + this.description();
        }

        @Override
        public String description() {
            return "list all networks in the jobmanager";
        }
    }

    private class NetworkRemove
    implements ICommand {
        @Override
        public String keyword() {
            return "remove";
        }

        @Override
        public int execute(CommandInfo info) {
            if (!CJobManager.this.isJobManagerRunning()) {
                System.err.println("The Job Manager is not running");
                return 1;
            }
            Parameter params = info.extractParameter(new ParameterInfo("uuid", "--uuid", "-u"));
            String uuid = params.get("uuid", null);
            uuid = uuid == null && info.canAdvance() ? info.getParams()[0] : params.get("uuid");
            JobManagerConfig jmc = CJobManager.this.getJobManagerConfig();
            String id = uuid;
            POPNetworkDetails pnd = Arrays.stream(jmc.availableNetworks()).filter(d -> d.getUUID().equals(id)).findFirst().orElse(null);
            if (pnd != null) {
                jmc.removeNetwork(uuid);
                System.out.format("Removed network [%s](%s)\n", pnd.getFriendlyName(), pnd.getUUID());
            } else {
                System.out.format("Couldn't find network with id %s\n", uuid);
            }
            return 0;
        }

        @Override
        public String help() {
            return "usage: jm netowrk remove [OPTIONS]\n" + this.description() + "\nAvailable options:\n  --uuid, -u          The UUID of the network to remove";
        }

        @Override
        public String description() {
            return "remove an existing network from the runnig job manager";
        }
    }

    private class NetworkCreate
    implements ICommand {
        @Override
        public String keyword() {
            return "create";
        }

        @Override
        public int execute(CommandInfo info) {
            if (!CJobManager.this.isJobManagerRunning()) {
                System.err.println("The Job Manager is not running");
                return 1;
            }
            Parameter params = info.extractParameter(new ParameterInfo("name", "--name", "-n"), new ParameterInfo("uuid", "--uuid", "-u"));
            String name = params.get("name");
            String uuid = params.get("uuid");
            JobManagerConfig jmc = CJobManager.this.getJobManagerConfig();
            POPNetworkDetails details = uuid == null || uuid.trim().isEmpty() ? jmc.createNetwork(name) : jmc.createNetwork(uuid, name);
            if (details != null) {
                System.out.format("Network '%s' created with id [%s]\n", details.getFriendlyName(), details.getUUID());
                byte[] pubCert = SSLUtils.certificateBytes(details.getCertificate());
                Path out = Paths.get(details.getFriendlyName() + "@" + details.getUUID() + ".cer", new String[0]);
                try {
                    Files.write(out, pubCert, new OpenOption[0]);
                    System.out.format("Network certificate available at '%s'\n", out.toAbsolutePath().toString());
                }
                catch (IOException ex) {
                    System.err.println("Couldn't write public certificate to disk.");
                }
            } else {
                System.err.println("Can't create network.");
                return 2;
            }
            return 0;
        }

        @Override
        public String help() {
            return "usage: jm netowrk create [OPTIONS]\n" + this.description() + "\nAvailable options:\n  --name, -n          A friendly name for this network\n  --uuid, -u          Assign a specific UUID to this network";
        }

        @Override
        public String description() {
            return "create a new network with a generated uuid or a fixed one";
        }
    }

    private class Network
    implements ICommand {
        private final CommandHandler commandNetworkHandler = new CommandHandler();

        public Network() {
            this.initNetworkCommands();
        }

        private void initNetworkCommands() {
            this.commandNetworkHandler.add(new NetworkCreate());
            this.commandNetworkHandler.add(new NetworkRemove());
            this.commandNetworkHandler.add(new NetworkList());
        }

        @Override
        public String keyword() {
            return "network";
        }

        @Override
        public int execute(CommandInfo info) {
            if (info.canAdvance()) {
                return this.commandNetworkHandler.execute(info.advance());
            }
            System.out.println(this.help());
            return 1;
        }

        @Override
        public String help() {
            return this.commandNetworkHandler.help();
        }

        @Override
        public String description() {
            return "operation on the job manager network";
        }
    }

    private class Stop
    implements ICommand {
        @Override
        public String keyword() {
            return "stop";
        }

        @Override
        public int execute(CommandInfo info) {
            if (!CJobManager.this.isJobManagerRunning()) {
                System.err.println("No job manager was found.");
                return 1;
            }
            PopJava.destroy(CJobManager.this.jobManager);
            CJobManager.this.jobManager = null;
            CJobManager.this.jobManagerConfig = null;
            return 0;
        }

        @Override
        public String help() {
            return "usage: jm start\n" + this.description();
        }

        @Override
        public String description() {
            return "stop the currently running job manager process";
        }
    }

    private class Start
    implements ICommand {
        @Override
        public String keyword() {
            return "start";
        }

        @Override
        public int execute(CommandInfo info) {
            if (CJobManager.this.isJobManagerRunning()) {
                System.err.println("The Job Manager is already running.");
                return 1;
            }
            Configuration conf = Configuration.getInstance();
            String[] protocols = conf.getJobManagerProtocols();
            int[] ports = conf.getJobManagerPorts();
            for (int i = 0; i < ports.length; ++i) {
                int n = i;
                protocols[n] = protocols[n] + ":" + ports[i];
            }
            ObjectDescription od = new ObjectDescription();
            od.setNetwork(POPJShell.configuration.getPrivateNetwork());
            CJobManager.this.jobManager = PopJava.newActive(POPJavaJobManager.class, od, "localhost", protocols);
            CJobManager.this.jobManager.start();
            System.out.println("Job Manager started.");
            return 0;
        }

        @Override
        public String help() {
            return "usage: jm start\n" + this.description();
        }

        @Override
        public String description() {
            return "start a job manager process";
        }
    }
}

