/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.external;

import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetwork;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Objects;

public class POPNetworkDetails
implements IPOPBase {
    private String uuid;
    private String friendlyName;
    private Certificate certificate;

    public POPNetworkDetails() {
    }

    public POPNetworkDetails(POPNetwork network) {
        this.uuid = network.getUUID();
        this.friendlyName = network.getFriendlyName();
        try {
            this.certificate = SSLUtils.getCertificateFromAlias(this.uuid);
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[NetworkDetails] No certificate found for network [%s].", this.uuid);
        }
    }

    public String getUUID() {
        return this.uuid;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        buffer.putString(this.uuid);
        buffer.putString(this.friendlyName);
        boolean hasCertificate = this.certificate != null;
        buffer.putBoolean(hasCertificate);
        if (hasCertificate) {
            buffer.putByteArray(SSLUtils.certificateBytes(this.certificate));
        }
        return true;
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        this.uuid = buffer.getString();
        this.friendlyName = buffer.getString();
        boolean hasCertificate = buffer.getBoolean();
        if (hasCertificate) {
            int certLength = buffer.getInt();
            try {
                this.certificate = SSLUtils.certificateFromBytes(buffer.getByteArray(certLength));
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 3;
        hash = 59 * hash + Objects.hashCode(this.uuid);
        hash = 59 * hash + Objects.hashCode(this.friendlyName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        POPNetworkDetails other = (POPNetworkDetails)obj;
        if (!Objects.equals(this.uuid, other.uuid)) {
            return false;
        }
        return Objects.equals(this.friendlyName, other.friendlyName);
    }
}

