/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.network;

import ch.icosys.popjava.core.baseobject.ConnectionType;
import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.interfacebase.Interface;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnector;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptorMethod;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.service.jobmanager.network.POPNodeDirect;
import java.util.List;

public class POPConnectorDirect
extends POPConnector {
    static final POPNetworkDescriptor DESCRIPTOR = new POPNetworkDescriptor("direct", new DescriptorMethodImpl());
    public static final String OD_SERVICE_PORT = "_service-port";

    public POPConnectorDirect() {
        super(DESCRIPTOR);
    }

    @Override
    public int createObject(POPAccessPoint localservice, String objname, ObjectDescription od, int howmany, POPAccessPoint[] objcontacts, int howmany2, POPAccessPoint[] remotejobcontacts) {
        POPNodeDirect node = (POPNodeDirect)this.nodes.get((int)(Math.random() * (double)this.nodes.size()));
        od.setHostname(node.getHost());
        od.setValue(OD_SERVICE_PORT, node.getPort() + "");
        od.setConnectionType(ConnectionType.SSH);
        od.setConnectionSecret(node.getDaemonSecret());
        if (node.isDaemon()) {
            od.setConnectionType(ConnectionType.DAEMON);
        }
        for (int i = 0; i < howmany; ++i) {
            boolean bl = Interface.tryLocal(objname, objcontacts[i], od);
        }
        return 0;
    }

    private static class DescriptorMethodImpl
    implements POPNetworkDescriptorMethod {
        private DescriptorMethodImpl() {
        }

        @Override
        public POPConnector createConnector() {
            return new POPConnectorDirect();
        }

        @Override
        public POPNode createNode(List<String> params) {
            return new POPNodeDirect(params);
        }
    }
}

