/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.network;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.base.POPObject;
import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.service.jobmanager.Resource;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnector;
import ch.icosys.popjava.core.service.jobmanager.network.POPConnectorSearchNodeInterface;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptor;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptorMethod;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import ch.icosys.popjava.core.service.jobmanager.network.POPNodeTFC;
import ch.icosys.popjava.core.service.jobmanager.search.SNExploration;
import ch.icosys.popjava.core.service.jobmanager.search.SNNodesInfo;
import ch.icosys.popjava.core.service.jobmanager.search.SNRequest;
import ch.icosys.popjava.core.service.jobmanager.search.SNResponse;
import ch.icosys.popjava.core.service.jobmanager.search.SNWayback;
import ch.icosys.popjava.core.service.jobmanager.tfc.TFCResource;
import ch.icosys.popjava.core.system.POPSystem;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.Util;
import ch.icosys.popjava.core.util.ssl.SSLUtils;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class POPConnectorTFC
extends POPConnector
implements POPConnectorSearchNodeInterface {
    static final POPNetworkDescriptor DESCRIPTOR = new POPNetworkDescriptor("tfc", new DescriptorMethodImpl());
    private final Configuration conf = Configuration.getInstance();
    private static final String TFC_REQ_OBJECT = "_tfc_object";
    private static final String TFC_RES_ACCESS_POINT = "_tfc_access_point";
    private final Map<String, List<TFCResource>> tfcObjects = new HashMap<String, List<TFCResource>>();

    public POPConnectorTFC() {
        super(DESCRIPTOR);
    }

    @Override
    public int createObject(POPAccessPoint localservice, String objname, ObjectDescription od, int howmany, POPAccessPoint[] objcontacts, int howmany2, POPAccessPoint[] remotejobcontacts) {
        SNRequest request = new SNRequest(Util.generateUUID(), new Resource(), new Resource(), this.network.getUUID(), this.getDescriptor().getGlobalName(), null);
        if (od.getSearchMaxDepth() > 0) {
            request.setHopLimit(od.getSearchMaxDepth());
        }
        if (od.getSearchMaxSize() > 0) {
            // empty if block
        }
        int timeout = this.conf.getTFCSearchTimeout();
        if (od.getSearchWaitTime() >= 0) {
            timeout = od.getSearchWaitTime();
        }
        if (!od.getPlatform().isEmpty()) {
            request.setOS(od.getPlatform());
        }
        if (od.getSearchHosts().length > 0) {
            request.setHosts(od.getSearchHosts());
        }
        request.setValue(TFC_REQ_OBJECT, objname);
        SNNodesInfo remoteJobMngs = this.jobManager.launchDiscovery(request, timeout);
        if (remoteJobMngs.isEmpty()) {
            throw new POPException(10005, "No answer from the network while looking for TFC resource " + objname);
        }
        for (int i = 0; i < howmany && i < remoteJobMngs.size(); ++i) {
            String objAP;
            if (objcontacts[i] == null || (objAP = remoteJobMngs.get(i).getValue(TFC_RES_ACCESS_POINT)) == null || objAP.isEmpty()) continue;
            objcontacts[i].setAccessString(objAP);
            byte[] cert = remoteJobMngs.get(i).getCertificate();
            if (cert == null || cert.length <= 0) continue;
            objcontacts[i].setFingerprint(SSLUtils.certificateFingerprint(cert));
            objcontacts[i].setX509certificate(cert);
        }
        return 0;
    }

    public void unregisterObject(TFCResource resource) {
        List<TFCResource> localTFCObjects = this.tfcObjects.get(resource.getObjectName());
        if (localTFCObjects == null) {
            return;
        }
        TFCResource liveResource = null;
        for (TFCResource localTFCObject : localTFCObjects) {
            if (!localTFCObject.equals(resource)) continue;
            liveResource = localTFCObject;
            break;
        }
        if (liveResource == null) {
            return;
        }
        if (!liveResource.getSecret().equals(resource.getSecret())) {
            return;
        }
        LogWriter.writeDebugInfo("[TFC] unregistering " + liveResource);
        localTFCObjects.remove(liveResource);
    }

    public boolean registerObject(TFCResource resource) {
        List<TFCResource> localTFCObjects = this.tfcObjects.get(resource.getObjectName());
        if (localTFCObjects == null) {
            localTFCObjects = new LinkedList<TFCResource>();
            this.tfcObjects.put(resource.getObjectName(), localTFCObjects);
        }
        for (TFCResource localTFCObject : localTFCObjects) {
            if (!localTFCObject.equals(resource)) continue;
            return true;
        }
        LogWriter.writeDebugInfo("[TFC] registering " + resource);
        return localTFCObjects.add(resource);
    }

    private List<TFCResource> getAliveTFCResources(String tfcObject, byte[] cert) {
        List<TFCResource> resources = this.tfcObjects.get(tfcObject);
        if (resources == null) {
            return null;
        }
        Iterator<TFCResource> iterator = resources.iterator();
        while (iterator.hasNext()) {
            TFCResource tfcResource = iterator.next();
            try {
                POPObject aliveTest = PopJava.connect(null, POPObject.class, this.network.getUUID(), tfcResource.getAccessPoint());
                if (cert != null && cert.length != 0) {
                    aliveTest.PopRegisterFutureConnectorCertificate(cert);
                }
                aliveTest.exit();
            }
            catch (Exception e) {
                iterator.remove();
                LogWriter.writeDebugInfo("[TFC] unavailable %s removed ", tfcResource);
            }
        }
        return Collections.unmodifiableList(resources);
    }

    public List<TFCResource> getObjects(String tfcObject, Certificate cert) {
        List<TFCResource> resources;
        byte[] bytes = null;
        if (cert != null) {
            bytes = SSLUtils.certificateBytes(cert);
        }
        if ((resources = this.getAliveTFCResources(tfcObject, bytes)) == null) {
            return null;
        }
        return resources;
    }

    @Override
    public void askResourcesDiscoveryAction(SNRequest request, POPAccessPoint sender, SNExploration oldExplorationList) {
        String tfcObject = request.getValue(TFC_REQ_OBJECT);
        if (tfcObject == null) {
            return;
        }
        LogWriter.writeDebugInfo("[TFC] handling;%s;%s", request.getUID(), tfcObject);
        List<TFCResource> resources = this.getAliveTFCResources(tfcObject, request.getPublicCertificate());
        if (resources == null) {
            LogWriter.writeDebugInfo("[TFC] no resource found for %s", tfcObject);
            return;
        }
        LogWriter.writeDebugInfo("[TFC] found %d object(s)", resources.size());
        for (TFCResource tfcResource : resources) {
            SNNodesInfo.Node nodeinfo = new SNNodesInfo.Node(this.jobManager.getNodeId(), this.jobManager.getAccessPoint(), POPSystem.getPlatform(), new Resource());
            String resourceString = tfcResource.getAccessPoint().toString();
            nodeinfo.setValue(TFC_RES_ACCESS_POINT, resourceString);
            SNResponse response = new SNResponse(request.getUID(), request.getNetworkUUID(), request.getExplorationList(), nodeinfo);
            if (request.getPublicCertificate().length > 0) {
                SSLUtils.addCertToTempStore(request.getPublicCertificate());
            }
            LogWriter.writeDebugInfo("[TFC] aswering request %s of %s with %s.", request.getUID(), tfcObject, resourceString);
            this.jobManager.rerouteResponse(response, new SNWayback(request.getWayback()));
        }
    }

    @Override
    public boolean broadcastPresence() {
        return false;
    }

    private static class DescriptorMethodImpl
    implements POPNetworkDescriptorMethod {
        private DescriptorMethodImpl() {
        }

        @Override
        public POPConnector createConnector() {
            return new POPConnectorTFC();
        }

        @Override
        public POPNode createNode(List<String> params) {
            return new POPNodeTFC(params);
        }
    }
}

