/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.network;

import ch.icosys.popjava.core.service.jobmanager.network.POPConnector;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptorFinder;
import ch.icosys.popjava.core.service.jobmanager.network.POPNetworkDescriptorMethod;
import ch.icosys.popjava.core.service.jobmanager.network.POPNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class POPNetworkDescriptor {
    private final String globalName;
    private final POPNetworkDescriptorMethod methods;

    public static POPNetworkDescriptor from(String globalName) {
        return POPNetworkDescriptorFinder.getInstance().find(globalName);
    }

    public POPNetworkDescriptor(String globalName, POPNetworkDescriptorMethod methods) {
        this.globalName = globalName;
        this.methods = methods;
    }

    public String getGlobalName() {
        return this.globalName;
    }

    public POPConnector createConnector() {
        return this.methods.createConnector();
    }

    public POPNode createNode(List<String> params) {
        params = new ArrayList<String>(params);
        return this.methods.createNode(params);
    }

    public String toString() {
        return this.getGlobalName();
    }

    public int hashCode() {
        int hash = 7;
        hash = 43 * hash + Objects.hashCode(this.globalName);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        POPNetworkDescriptor other = (POPNetworkDescriptor)obj;
        return Objects.equals(this.globalName, other.globalName);
    }
}

