/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.service.jobmanager.search;

import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.buffer.POPBuffer;
import ch.icosys.popjava.core.dataswaper.IPOPBase;
import ch.icosys.popjava.core.service.jobmanager.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SNNodesInfo
implements IPOPBase {
    private final List<Node> nodes = new ArrayList<Node>();

    public boolean add(Node e) {
        return this.nodes.add(e);
    }

    public boolean remove(Node o) {
        return this.nodes.remove(o);
    }

    public void clear() {
        this.nodes.clear();
    }

    public Node get(int index) {
        return this.nodes.get(index);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int size() {
        return this.nodes.size();
    }

    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    @Override
    public boolean serialize(POPBuffer buffer) {
        buffer.putInt(this.nodes.size());
        for (Node n : this.nodes) {
            n.serialize(buffer);
        }
        return true;
    }

    @Override
    public boolean deserialize(POPBuffer buffer) {
        int size = buffer.getInt();
        for (int i = 0; i < size; ++i) {
            this.nodes.add((Node)buffer.getValue(Node.class));
        }
        return true;
    }

    public static class Node
    implements IPOPBase {
        private String nodeID;
        private POPAccessPoint jobManager;
        private String os;
        private Resource resources;
        private final Map<String, String> customParams = new HashMap<String, String>();
        private byte[] certificate = new byte[0];

        public Node() {
        }

        public Node(String nodeID, POPAccessPoint jobManager, String os, Resource resources) {
            this.nodeID = nodeID;
            this.jobManager = jobManager;
            this.os = os;
            this.resources = resources;
        }

        public String getNodeID() {
            return this.nodeID;
        }

        public void setNodeID(String nodeID) {
            this.nodeID = nodeID;
        }

        public POPAccessPoint getJobManager() {
            return this.jobManager;
        }

        public void setJobManager(POPAccessPoint jobManager) {
            this.jobManager = jobManager;
        }

        public String getOs() {
            return this.os;
        }

        public void setOs(String os) {
            this.os = os;
        }

        public Resource getResources() {
            return this.resources;
        }

        public void setResources(Resource resources) {
            this.resources = resources;
        }

        public void setValue(String key, String value) {
            this.customParams.put(key, value);
        }

        public String getValue(String key) {
            return this.customParams.get(key);
        }

        public void setCertificate(byte[] certificate) {
            this.certificate = certificate;
        }

        public byte[] getCertificate() {
            return this.certificate;
        }

        @Override
        public boolean serialize(POPBuffer buffer) {
            buffer.putString(this.nodeID);
            buffer.putValue(this.jobManager, POPAccessPoint.class);
            buffer.putString(this.os);
            buffer.putValue(this.resources, Resource.class);
            buffer.putByteArray(this.certificate);
            buffer.putInt(this.customParams.size());
            for (Map.Entry<String, String> entry : this.customParams.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                buffer.putString(key);
                buffer.putString(value);
            }
            return true;
        }

        @Override
        public boolean deserialize(POPBuffer buffer) {
            this.nodeID = buffer.getString();
            this.jobManager = (POPAccessPoint)buffer.getValue(POPAccessPoint.class);
            this.os = buffer.getString();
            this.resources = (Resource)buffer.getValue(Resource.class);
            int certSize = buffer.getInt();
            this.certificate = buffer.getByteArray(certSize);
            int mapSize = buffer.getInt();
            for (int i = 0; i < mapSize; ++i) {
                this.customParams.put(buffer.getString(), buffer.getString());
            }
            return true;
        }
    }
}

