/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.system;

import ch.icosys.popjava.core.broker.Broker;
import ch.icosys.popjava.core.system.ConfigurationWorker;
import ch.icosys.popjava.core.system.POPSystem;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;

public class POPJavaConfiguration {
    private static final String DEFAULT_POPJ_LOCATION = "/usr/local/popj";
    private static String popJavaLocation = null;

    private static String getConfigurationValue(String value) {
        try {
            ConfigurationWorker cw = new ConfigurationWorker();
            String string = cw.getValue(value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getBrokerCommand() {
        String brokerCommand = POPJavaConfiguration.getConfigurationValue("popj_broker_command");
        if (brokerCommand == null) {
            brokerCommand = "java -javaagent:%s -cp %s " + Broker.class.getName() + " " + "-codelocation=";
        }
        return brokerCommand;
    }

    public static String getPopAppCoreService() {
        String appCoreService = POPJavaConfiguration.getConfigurationValue("popc_appcoreservice_location");
        if (appCoreService == null) {
            appCoreService = "/usr/local/popc/services/appservice";
        }
        return appCoreService;
    }

    public static synchronized String getPopJavaLocation() {
        if (popJavaLocation != null) {
            return popJavaLocation;
        }
        popJavaLocation = POPJavaConfiguration.getConfigurationValue("popj_location");
        if (popJavaLocation == null) {
            if (new File(DEFAULT_POPJ_LOCATION).exists()) {
                popJavaLocation = DEFAULT_POPJ_LOCATION;
            } else {
                URL temp = POPJavaConfiguration.getMyJar();
                if (temp != null) {
                    File source = new File(temp.getFile()).getParentFile().getParentFile();
                    popJavaLocation = source.getAbsolutePath();
                } else {
                    popJavaLocation = "";
                }
            }
        }
        return popJavaLocation;
    }

    private static URL getMyJar() {
        URL url;
        POPJavaConfiguration me = new POPJavaConfiguration();
        if (me.getClass().getClassLoader() instanceof URLClassLoader) {
            for (URL url2 : ((URLClassLoader)me.getClass().getClassLoader()).getURLs()) {
                URL finalUrl = POPJavaConfiguration.checkJarURL(url2);
                if (finalUrl == null) continue;
                return finalUrl;
            }
        } else if (me.getClass().getProtectionDomain() != null && me.getClass().getProtectionDomain().getCodeSource() != null && (url = POPJavaConfiguration.checkJarURL(me.getClass().getProtectionDomain().getCodeSource().getLocation())) != null) {
            return url;
        }
        return null;
    }

    private static URL checkJarURL(URL url) {
        boolean exists = false;
        try {
            exists = new File(url.toURI()).exists();
        }
        catch (Exception e) {
            exists = new File(url.getPath()).exists();
        }
        if (url.getFile().endsWith("popjava.jar") && exists) {
            return url;
        }
        return null;
    }

    public static String getPopPluginLocation() {
        String popJavaPluginLocation = POPJavaConfiguration.getConfigurationValue("popj_plugin_location");
        if (popJavaPluginLocation == null) {
            popJavaPluginLocation = "";
        }
        return popJavaPluginLocation;
    }

    public static boolean isJar() {
        CodeSource temp = POPSystem.class.getProtectionDomain().getCodeSource();
        if (temp != null) {
            File location = null;
            try {
                location = new File(temp.getLocation().toURI());
            }
            catch (URISyntaxException e) {
                location = new File(temp.getLocation().getPath());
            }
            if (location.isFile() && location.getAbsolutePath().endsWith(".jar")) {
                return true;
            }
        }
        return false;
    }

    public static String getClassPath() {
        String path = System.getProperty("java.class.path");
        String[] parts = path.split(File.pathSeparator);
        path = "";
        for (int i = 0; i < parts.length; ++i) {
            path = parts[i].contains(" ") ? path + "\"" + parts[i] + "\"" : path + parts[i];
            if (i >= parts.length - 1) continue;
            path = path + File.pathSeparator;
        }
        return path;
    }

    public static String getPOPJavaCodePath() {
        String popJar = "";
        CodeSource temp = POPSystem.class.getProtectionDomain().getCodeSource();
        if (temp != null) {
            File location = null;
            try {
                location = new File(temp.getLocation().toURI());
            }
            catch (URISyntaxException e) {
                location = new File(temp.getLocation().getPath());
            }
            if (location.isFile() && location.getAbsolutePath().endsWith(".jar")) {
                popJar = location.getAbsolutePath();
            }
        }
        if (popJar.isEmpty()) {
            popJar = POPJavaConfiguration.getClassPath();
        }
        return popJar;
    }

    public static String getPopJavaJar() {
        String popJar = "";
        CodeSource temp = POPSystem.class.getProtectionDomain().getCodeSource();
        if (temp != null) {
            File location = null;
            try {
                location = new File(temp.getLocation().toURI());
            }
            catch (URISyntaxException e) {
                location = new File(temp.getLocation().getPath());
            }
            if (location.isFile() && location.getAbsolutePath().endsWith(".jar")) {
                popJar = location.toPath().toString();
            }
        }
        if (!popJar.endsWith(".jar")) {
            popJar = new File("build/popjava.jar").toPath().toString();
        }
        return popJar;
    }
}

