/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.system;

import ch.icosys.popjava.core.PopJava;
import ch.icosys.popjava.core.base.POPException;
import ch.icosys.popjava.core.baseobject.ObjectDescription;
import ch.icosys.popjava.core.baseobject.POPAccessPoint;
import ch.icosys.popjava.core.codemanager.AppService;
import ch.icosys.popjava.core.service.jobmanager.POPJavaAppService;
import ch.icosys.popjava.core.serviceadapter.POPAppService;
import ch.icosys.popjava.core.system.POPJavaConfiguration;
import ch.icosys.popjava.core.system.POPRemoteLogThread;
import ch.icosys.popjava.core.system.XMLWorker;
import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import ch.icosys.popjava.core.util.RuntimeDirectoryThread;
import ch.icosys.popjava.core.util.SystemUtil;
import ch.icosys.popjava.core.util.Util;
import ch.icosys.popjava.core.util.upnp.UPNPManager;
import java.io.File;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javassist.util.proxy.ProxyFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class POPSystem {
    private static POPRemoteLogThread prlt;
    private static String platform;
    private static volatile boolean initialized;
    private static ExecutorService asyncConstructorExecutor;
    private static final List<RuntimeDirectoryThread> localHooks;
    private static final Configuration conf;
    private static String jobservice;
    private static String codeconf;
    private static String appservicecode;
    private static String proxy;
    private static String appservicecontact;
    public static final String POP_LOCATION_ENVIRONMENT_NAME = "POP_LOCATION";
    public static POPAccessPoint jobService;
    private static AppService coreServiceManager;
    public static POPAccessPoint appServiceAccessPoint;
    private static boolean isStarted;

    public static void writeLog(String log) {
        if (!conf.isDebug()) {
            System.out.println(log);
        }
        LogWriter.writeDebugInfo(log);
    }

    public static int getIPAsInt() {
        try {
            InetAddress localAddress = InetAddress.getLocalHost();
            byte[] ip = localAddress.getAddress();
            return ip[0] * 256 * 256 * 256 + ip[1] * 256 * 256 + ip[2] * 256 + ip[3];
        }
        catch (UnknownHostException unknownHostException) {
            return 0x7F000000;
        }
    }

    public static InterfaceAddress getInterfaceIP(NetworkInterface ni, boolean allowPrivate) {
        try {
            if (ni != null && ni.isUp()) {
                Enumeration<InetAddress> enina = ni.getInetAddresses();
                for (InterfaceAddress interfaceAddress : ni.getInterfaceAddresses()) {
                    String address = interfaceAddress.getAddress().getHostAddress();
                    if (!allowPrivate && interfaceAddress.getAddress().isSiteLocalAddress() || address.contains(":") || address.equals("127.0.0.1") || address.equals("127.0.1.1") || address.isEmpty() || Util.getOSType() != Util.OSType.Windows && !interfaceAddress.getAddress().isReachable(20)) continue;
                    return interfaceAddress;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static InterfaceAddress getHostIP() {
        InterfaceAddress ip;
        NetworkInterface ni3;
        String preferedInterface = System.getenv("POPJ_IFACE");
        if (preferedInterface != null) {
            try {
                NetworkInterface ni2 = NetworkInterface.getByName(preferedInterface);
                InterfaceAddress ip2 = POPSystem.getInterfaceIP(ni2, true);
                if (ip2 != null) {
                    return ip2;
                }
            }
            catch (SocketException e) {
                LogWriter.writeExceptionLog(e);
            }
        }
        Enumeration<NetworkInterface> en = null;
        try {
            en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                ni3 = en.nextElement();
                ip = POPSystem.getInterfaceIP(ni3, false);
                if (ip == null) continue;
                return ip;
            }
        }
        catch (SocketException ni3) {
            // empty catch block
        }
        if (en != null) {
            while (en.hasMoreElements()) {
                ni3 = en.nextElement();
                ip = POPSystem.getInterfaceIP(ni3, true);
                if (ip == null) continue;
                return ip;
            }
        }
        try {
            InetAddress localHost = Inet4Address.getLocalHost();
            NetworkInterface networkInterface = NetworkInterface.getByInetAddress(localHost);
            if (networkInterface != null) {
                for (InterfaceAddress addr : networkInterface.getInterfaceAddresses()) {
                    if (!addr.getAddress().isLoopbackAddress() || !(addr.getAddress() instanceof Inet4Address)) continue;
                    return addr;
                }
                for (InterfaceAddress addr : networkInterface.getInterfaceAddresses()) {
                    if (!(addr.getAddress() instanceof Inet4Address)) continue;
                    return addr;
                }
            } else {
                NetworkInterface ni4;
                en = NetworkInterface.getNetworkInterfaces();
                while (en.hasMoreElements()) {
                    ni4 = en.nextElement();
                    for (InterfaceAddress interfaceAddress : ni4.getInterfaceAddresses()) {
                        if (!(interfaceAddress.getAddress() instanceof Inet4Address)) continue;
                        return interfaceAddress;
                    }
                }
                while (en.hasMoreElements()) {
                    InterfaceAddress interfaceAddress;
                    ni4 = en.nextElement();
                    Iterator<InterfaceAddress> iterator = ni4.getInterfaceAddresses().iterator();
                    if (!iterator.hasNext()) continue;
                    interfaceAddress = iterator.next();
                    return interfaceAddress;
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<InterfaceAddress> getAllHostIPs(boolean allowPrivate) {
        HashSet<InterfaceAddress> ips = new HashSet<InterfaceAddress>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                InterfaceAddress ip = POPSystem.getInterfaceIP(ni, allowPrivate);
                if (ip == null) continue;
                ips.add(ip);
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return new ArrayList<InterfaceAddress>(ips);
    }

    public static POPAccessPoint getDefaultAccessPoint() {
        POPAccessPoint parrocAccessPoint = new POPAccessPoint();
        parrocAccessPoint.setAccessString(String.format("%s://%s:0", conf.getDefaultProtocol(), POPSystem.getHostIP().getAddress().getHostAddress()));
        return parrocAccessPoint;
    }

    public static ObjectDescription getDefaultOD() {
        return new ObjectDescription();
    }

    public static String getEnviroment(String name) {
        String enviroment = System.getenv(name);
        enviroment = enviroment == null ? "" : enviroment.trim();
        return enviroment;
    }

    public static String getPlatform() {
        return platform;
    }

    private static String getNeededClasspath() {
        try {
            if (ProxyFactory.class.getProtectionDomain().getCodeSource().getLocation().getPath().equals(POPJavaConfiguration.getPopJavaJar())) {
                return POPJavaConfiguration.getPopJavaJar();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return POPJavaConfiguration.getPOPJavaCodePath();
    }

    public static String[] initialize(String ... args) {
        asyncConstructorExecutor = Executors.newFixedThreadPool(20);
        ArrayList<String> argvList = new ArrayList<String>(Arrays.asList(args));
        POPSystem.initialize(argvList);
        return argvList.toArray(new String[argvList.size()]);
    }

    public static void setStarted() {
        isStarted = true;
    }

    public static synchronized boolean start() {
        if (isStarted) {
            return true;
        }
        isStarted = true;
        jobService.setAccessString(jobservice);
        if (appservicecode == null || appservicecode.length() == 0) {
            appservicecode = POPJavaConfiguration.getPopAppCoreService();
        }
        if (!(jobservice != null && jobservice.length() != 0 || appservicecontact != null && appservicecontact.length() != 0)) {
            return false;
        }
        coreServiceManager = POPSystem.getCoreService(proxy, appservicecontact, appservicecode);
        if (coreServiceManager != null) {
            appServiceAccessPoint = coreServiceManager.getAccessPoint();
            prlt = new POPRemoteLogThread(coreServiceManager.getPOPCAppID());
            prlt.start();
        }
        if (codeconf == null || codeconf.isEmpty()) {
            codeconf = String.format("%s%setc%sdefaultobjectmap.xml", POPJavaConfiguration.getPopJavaLocation(), File.separator, File.separator);
        }
        String popJavaObjectExecuteCommand = String.format(POPJavaConfiguration.getBrokerCommand(), POPJavaConfiguration.getPopJavaJar(), POPSystem.getNeededClasspath());
        if (conf.isConnectToJavaJobmanager()) {
            // empty if block
        }
        initialized = POPSystem.initCodeService(codeconf, popJavaObjectExecuteCommand, coreServiceManager);
        RuntimeDirectoryThread runtimeCleanup = new RuntimeDirectoryThread(Util.generateUUID());
        runtimeCleanup.addCleanupHook();
        localHooks.add(runtimeCleanup);
        return initialized;
    }

    public static void registerCode(String file, String clazz) {
        POPSystem.start();
        String popJavaObjectExecuteCommand = String.format(POPJavaConfiguration.getBrokerCommand(), POPJavaConfiguration.getPopJavaJar(), POPSystem.getNeededClasspath());
        if (coreServiceManager != null) {
            coreServiceManager.registerCode(clazz, "*-*", popJavaObjectExecuteCommand + file);
        }
    }

    private static void initialize(List<String> argvList) {
        String tempJobservice = Util.removeStringFromList(argvList, "-jobservice=");
        if (tempJobservice != null && !tempJobservice.isEmpty()) {
            jobservice = tempJobservice;
        }
        codeconf = Util.removeStringFromList(argvList, "-codeconf=");
        appservicecode = Util.removeStringFromList(argvList, "-appservicecode=");
        proxy = Util.removeStringFromList(argvList, "-proxy=");
        appservicecontact = Util.removeStringFromList(argvList, "-appservicecontact=");
        String userConfig = Util.removeStringFromList(argvList, "-configfile=");
        if (userConfig != null) {
            File config = new File(userConfig);
            try {
                conf.load(config);
            }
            catch (IOException e) {
                LogWriter.writeDebugInfo("[Init] can't access user config '%s'", config.getAbsolutePath());
            }
        }
    }

    private static AppService getCoreService(String proxy, String appservicecontact, String appservicecode) {
        LogWriter.printDebug("getCoreService " + proxy + " " + appservicecontact + " " + appservicecode);
        if (appservicecontact == null || appservicecontact.length() == 0) {
            String url = "";
            url = proxy == null || proxy.length() == 0 ? appservicecode : String.format("%s -proxy=%s", appservicecode, proxy);
            if (conf.isConnectToPOPcpp() && (appservicecode.contains(" ") || new File(appservicecode).exists())) {
                try {
                    return POPSystem.createAppCoreService(url);
                }
                catch (POPException e) {
                    e.printStackTrace();
                }
            }
        } else {
            POPAccessPoint accessPoint = new POPAccessPoint();
            accessPoint.setAccessString(appservicecontact);
            try {
                return PopJava.newActiveConnect(null, POPAppService.class, accessPoint);
            }
            catch (POPException pOPException) {
                // empty catch block
            }
        }
        try {
            LogWriter.writeDebugInfo("Create appservice in Java");
            return PopJava.newActive(null, POPJavaAppService.class, new Object[0]);
        }
        catch (POPException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean initCodeService(String fileconf, String popJavaObjectExecuteCommand, AppService appCoreService) throws POPException {
        fileconf = fileconf.trim();
        XMLWorker xw = new XMLWorker();
        String mapXsd = POPJavaConfiguration.getPopJavaLocation() + "/etc/objectmap.xsd";
        if (!new File(mapXsd).exists() && !new File(mapXsd = "etc/objectmap.xsd").exists()) {
            LogWriter.printDebug("Could not open objectmap.xsd at " + mapXsd);
            return false;
        }
        if (!new File(fileconf).exists()) {
            LogWriter.printDebug("Could not open " + fileconf);
            return false;
        }
        if (!xw.isValid(fileconf, mapXsd)) {
            throw new POPException(0, "Object map not valid");
        }
        if (appCoreService == null || fileconf == null || fileconf.length() == 0) {
            return false;
        }
        fileconf = fileconf.replaceAll("\"", "");
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new File(fileconf));
            Element codeInfoListElement = document.getDocumentElement();
            NodeList list = codeInfoListElement.getChildNodes();
            for (int index = 0; index < list.getLength(); ++index) {
                Node node = list.item(index);
                String objectname = "";
                String codefile = "";
                String platform = "";
                if (node.getNodeType() != 1 || !node.getNodeName().equals("CodeInfo")) continue;
                for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    if (childNode.getNodeType() != 1) continue;
                    if (childNode.getNodeName().equals("ObjectName")) {
                        objectname = childNode.getTextContent();
                        continue;
                    }
                    if (childNode.getNodeName().equals("CodeFile")) {
                        codefile = childNode.getTextContent();
                        Element codeFileElement = (Element)childNode;
                        String codeFileType = codeFileElement.getAttribute("Type");
                        if (codeFileType == null || !codeFileType.equalsIgnoreCase("popjava")) continue;
                        codefile = popJavaObjectExecuteCommand + codefile;
                        continue;
                    }
                    if (!childNode.getNodeName().equals("PlatForm")) continue;
                    platform = childNode.getTextContent();
                }
                appCoreService.registerCode(objectname, platform, codefile);
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static AppService createAppCoreService(String codelocation) throws POPException {
        Random random = new Random(new Date().getTime());
        int maxUsignedByte = 255;
        byte[] bytes = new byte[255];
        random.nextBytes(bytes);
        StringBuilder randString = new StringBuilder();
        for (int i = 0; i < 255; ++i) {
            char randChar = (char)((double)(bytes[i] + 128) / (double)maxUsignedByte * 25.0 + 97.0);
            randString.append(randChar);
        }
        ObjectDescription objectDescription = POPSystem.getDefaultOD();
        objectDescription.setHostname(POPSystem.getHostIP().getAddress().getHostAddress());
        objectDescription.setCodeFile(codelocation);
        return PopJava.newActive(POPAppService.class, objectDescription, randString.toString(), false, codelocation);
    }

    public static void end() {
        LogWriter.writeDebugInfo("Shutting down POP-Java");
        POPSystem.waitForAsyncConstructors();
        asyncConstructorExecutor.shutdownNow();
        if (coreServiceManager != null) {
            coreServiceManager.exit();
        }
        SystemUtil.endAllChildren();
        if (prlt != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            prlt.setRunning(false);
        }
        UPNPManager.close();
        for (RuntimeDirectoryThread localHook : localHooks) {
            try {
                localHook.cleanup();
                localHook.removeCleanupHook();
            }
            catch (IOException e) {
                LogWriter.writeDebugInfo("[POPSystem] Failed to cleanup base directory %s", localHook.getBasePath());
            }
        }
        localHooks.clear();
        prlt = null;
        appservicecode = null;
        appservicecontact = null;
        initialized = false;
        isStarted = false;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static void startAsyncConstructor(Runnable constructor) {
        asyncConstructorExecutor.execute(constructor);
    }

    public static void waitForAsyncConstructors() {
        try {
            asyncConstructorExecutor.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    static {
        platform = "linux";
        initialized = false;
        asyncConstructorExecutor = Executors.newFixedThreadPool(20);
        localHooks = new ArrayList<RuntimeDirectoryThread>();
        conf = Configuration.getInstance();
        jobservice = String.format("%s:%d", POPSystem.getHostIP().getAddress().getHostAddress(), conf.getJobManagerPorts()[0]);
        jobService = new POPAccessPoint();
        appServiceAccessPoint = new POPAccessPoint();
        try {
            String osName = System.getProperty("os.name");
            String osArchitect = System.getProperty("os.arch");
            if (osName == null) {
                osName = "";
            }
            if (osArchitect == null) {
                osArchitect = "";
            }
            if (osArchitect.contains("64")) {
                osArchitect = "x86_64";
            }
            platform = String.format("%s-%s", osArchitect, osName);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        isStarted = false;
    }
}

