/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util;

import ch.icosys.popjava.core.annotation.POPClass;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javassist.util.proxy.ProxyObject;

public class ClassUtil {
    private static final Map<Method, String> methodSignsCache = new HashMap<Method, String>();
    private static final Map<Constructor, String> constructorSignsCache = new HashMap<Constructor, String>();

    public static Class<?>[] getObjectTypes(Object ... objects) {
        Class[] parameterTypes = new Class[objects.length];
        for (int index = 0; index < objects.length; ++index) {
            if (objects[index] == null) {
                parameterTypes[index] = Object.class;
                continue;
            }
            parameterTypes[index] = objects[index].getClass();
            if (ProxyObject.class.isAssignableFrom(parameterTypes[index])) {
                parameterTypes[index] = parameterTypes[index].getSuperclass();
            }
            if (objects[index].getClass().equals(Integer.class)) {
                parameterTypes[index] = Integer.TYPE;
                continue;
            }
            if (objects[index].getClass().equals(Double.class)) {
                parameterTypes[index] = Double.TYPE;
                continue;
            }
            if (objects[index].getClass().equals(Long.class)) {
                parameterTypes[index] = Long.TYPE;
                continue;
            }
            if (objects[index].getClass().equals(Short.class)) {
                parameterTypes[index] = Short.TYPE;
                continue;
            }
            if (!objects[index].getClass().equals(Boolean.class)) continue;
            parameterTypes[index] = Boolean.TYPE;
        }
        return parameterTypes;
    }

    public static Constructor<?> getConstructor(Class<?> c, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Constructor<?>[] allConstructors;
        for (Constructor<?> constructor : allConstructors = c.getConstructors()) {
            if (!ClassUtil.isSameConstructor(constructor, parameterTypes)) continue;
            return constructor;
        }
        String sign = ClassUtil.getMethodSign(c.getName(), parameterTypes);
        String errorMessage = String.format("Cannot find the method %s in class %s", sign, c.getName());
        throw new NoSuchMethodException(errorMessage);
    }

    public static Method getMethod(Class<?> c, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method[] allMethods;
        String sign = ClassUtil.getMethodSign(methodName, parameterTypes);
        for (Method method : allMethods = c.getMethods()) {
            if (sign.compareTo(ClassUtil.getMethodSign(method)) != 0) continue;
            return method;
        }
        String errorMessage = String.format("Cannot find the method %s in class %s", sign, c.getName());
        throw new NoSuchMethodException(errorMessage);
    }

    public static String getMethodSign(Method m) {
        Objects.requireNonNull(m);
        String sign = methodSignsCache.get(m);
        if (sign == null) {
            sign = ClassUtil.getMethodSign(m.getReturnType() + "@" + m.getName(), m.getParameterTypes());
            methodSignsCache.put(m, sign);
        }
        return sign;
    }

    public static String getMethodSign(Constructor<?> c) {
        Objects.requireNonNull(c);
        String sign = constructorSignsCache.get(c);
        if (sign == null) {
            sign = ClassUtil.getMethodSign(c.getDeclaringClass().getName(), c.getParameterTypes());
            constructorSignsCache.put(c, sign);
        }
        return sign;
    }

    private static String getMethodSign(String name, Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        for (Class<?> c : parameterTypes) {
            sb.append("-");
            sb.append(ClassUtil.getClassName(c));
        }
        return sb.toString();
    }

    public static boolean isAssignableFrom(Class<?> first, Class<?> second) {
        first = ClassUtil.normalizeType(first);
        second = ClassUtil.normalizeType(second);
        return first.isAssignableFrom(second);
    }

    private static Class<?> normalizeType(Class<?> first) {
        if (first.isPrimitive()) {
            if (first.equals(Boolean.TYPE)) {
                first = Boolean.class;
            } else if (first.equals(Byte.TYPE)) {
                first = Byte.class;
            } else if (first.equals(Character.TYPE)) {
                first = Character.class;
            } else if (first.equals(Short.TYPE)) {
                first = Short.class;
            } else if (first.equals(Integer.TYPE)) {
                first = Integer.class;
            } else if (first.equals(Long.TYPE)) {
                first = Long.class;
            } else if (first.equals(Float.TYPE)) {
                first = Float.class;
            } else if (first.equals(Double.TYPE)) {
                first = Double.class;
            }
        }
        return first;
    }

    private static boolean isSameConstructor(Constructor<?> constructor, Class<?>[] params) {
        if (params == null) {
            return false;
        }
        Class<?>[] parameters = constructor.getParameterTypes();
        return ClassUtil.areParameterTypesTheSame(params, parameters);
    }

    public static boolean areParameterTypesTheSame(Class<?>[] params, Class<?>[] constructorParameters) {
        if (constructorParameters.length > params.length || constructorParameters.length == 0 && params.length > 0) {
            return false;
        }
        for (int index = 0; index < constructorParameters.length; ++index) {
            if (index == constructorParameters.length - 1) {
                if (ClassUtil.isAssignableFrom(constructorParameters[index], params[index])) {
                    return constructorParameters.length == params.length;
                }
                if (constructorParameters[index].isArray()) {
                    Class<?> componentClass = constructorParameters[index].getComponentType();
                    for (int i = index; i < params.length; ++i) {
                        if (ClassUtil.isAssignableFrom(componentClass, params[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if (ClassUtil.isAssignableFrom(constructorParameters[index], params[index])) continue;
            return false;
        }
        return true;
    }

    private static String getClassName(Class<?> c) {
        if (c == Byte.TYPE) {
            return Byte.class.getName();
        }
        if (c == Integer.TYPE) {
            return Integer.class.getName();
        }
        if (c == Short.TYPE) {
            return Short.class.getName();
        }
        if (c == Long.TYPE) {
            return Long.class.getName();
        }
        if (c == Float.TYPE) {
            return Float.class.getName();
        }
        if (c == Double.TYPE) {
            return Double.class.getName();
        }
        if (c == Boolean.TYPE) {
            return Boolean.class.getName();
        }
        if (c == Character.TYPE) {
            return Character.class.getName();
        }
        return c.getName();
    }

    public static Object getDefaultPrimitiveValue(Class<?> c) {
        if (c == Byte.TYPE) {
            return (byte)0;
        }
        if (c == Integer.TYPE) {
            return 0;
        }
        if (c == Short.TYPE) {
            return (short)0;
        }
        if (c == Long.TYPE) {
            return 0L;
        }
        if (c == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (c == Double.TYPE) {
            return 0.0;
        }
        if (c == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (c == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    public static int classId(Class<?> clazz) {
        for (Annotation annotation : clazz.getDeclaredAnnotations()) {
            POPClass popClassAnnotation;
            if (!(annotation instanceof POPClass) || (popClassAnnotation = (POPClass)annotation).classId() == -1) continue;
            return popClassAnnotation.classId();
        }
        return Math.abs(clazz.getName().hashCode());
    }
}

