/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util;

import ch.icosys.popjava.core.system.POPJavaConfiguration;
import ch.icosys.popjava.core.util.Configuration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Date;

public class LogWriter {
    private static final String LOG_FOLDER_NAME = "logFolder";
    private static final String DEFAULT_LOCATION = "/usr/local/popj/logFolder";
    private static final Configuration conf = Configuration.getInstance();
    private static String pid = "";
    public static String logFolder;
    public static String prefix;

    public static void writeLogInfo(String info, String filePath) {
        info = pid + "-" + new Date().toString() + ":" + System.currentTimeMillis() + "-" + info;
        info = info + "\r\n";
        LogWriter.writeLogfile(info, filePath);
    }

    public static synchronized void printDebug(String message) {
        if (conf.isDebug()) {
            System.out.println(message);
        }
    }

    public static synchronized void writeDebugInfo(String info) {
        if (conf.isDebug()) {
            System.out.println(info);
            LogWriter.logInfo(info);
        }
    }

    public static synchronized void writeDebugInfo(String format, Object ... args) {
        if (conf.isDebug()) {
            String formattedInfo = String.format(format, args);
            System.out.println(formattedInfo);
            LogWriter.logInfo(formattedInfo);
        }
    }

    private static void logInfo(String info) {
        if (conf.isDebug()) {
            info = pid + "-" + new Date().toString() + ":" + System.currentTimeMillis() + "-" + info;
            info = info + "\r\n";
            String path = String.format("%s%s%s.txt", logFolder, File.separator, prefix);
            LogWriter.writeLogfile(info, path);
        }
    }

    public static void writeExceptionLog(Throwable e) {
        if (conf.isDebug()) {
            e.printStackTrace();
        }
        LogWriter.logInfo("Exception " + e.getClass().getName() + " " + e.getMessage());
        for (StackTraceElement trace : e.getStackTrace()) {
            LogWriter.logInfo(trace.getClassName() + " " + trace.getLineNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void writeLogfile(String info, String path) {
        path = path.replace(".txt", pid + ".txt");
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(path, true));
            out.write(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean deleteLogDir() {
        String[] children;
        File dir = new File(logFolder);
        for (String child : children = dir.list()) {
            new File(dir, child).delete();
        }
        return true;
    }

    static {
        prefix = "pop-java-";
        String pidTemp = ManagementFactory.getRuntimeMXBean().getName();
        StringBuilder pidSb = new StringBuilder();
        for (int index = 0; index < pidTemp.length(); ++index) {
            char c = pidTemp.charAt(index);
            if (!Character.isLetterOrDigit(c)) continue;
            pidSb.append(c);
        }
        pid = pidSb.toString();
        String popLocation = POPJavaConfiguration.getPopJavaLocation();
        logFolder = !popLocation.isEmpty() ? String.format("%s%s%s", popLocation, File.separator, LOG_FOLDER_NAME) : DEFAULT_LOCATION;
        if (!new File(logFolder).mkdirs()) {
            logFolder = System.getProperty("java.io.tmpdir");
        }
    }
}

