/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util;

import ch.icosys.popjava.core.util.Configuration;
import ch.icosys.popjava.core.util.LogWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class RuntimeDirectoryThread
extends Thread {
    private final Path origin;
    private Path basePath;
    private boolean done = false;

    public RuntimeDirectoryThread(String id) {
        Objects.requireNonNull(id);
        this.origin = Paths.get(".", new String[0]).toAbsolutePath();
        this.basePath = Paths.get(id, new String[0]).toAbsolutePath();
        this.init(id);
    }

    public RuntimeDirectoryThread(File dir) {
        Objects.requireNonNull(dir);
        this.origin = Paths.get(".", new String[0]).toAbsolutePath();
        this.basePath = dir.toPath().toAbsolutePath();
        this.init(this.basePath.getFileName().toString());
    }

    private void init(String id) {
        Configuration conf = Configuration.getInstance();
        try {
            this.basePath = Files.createDirectories(this.basePath, new FileAttribute[0]);
        }
        catch (IOException e) {
            try {
                this.basePath = Files.createTempDirectory(String.format("popjava-%s", id), new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RuntimeException("Broker couldn't create the object directory.");
            }
        }
        conf.setSSLTemporaryCertificateDirectory(this.basePath.toFile());
    }

    @Override
    public void run() {
        try {
            this.cleanup();
        }
        catch (IOException e) {
            LogWriter.writeDebugInfo("[Broker] A problem occurred when cleaning up: %s", e.getMessage());
        }
    }

    public void addCleanupHook() {
        Runtime.getRuntime().addShutdownHook(this);
    }

    public void removeCleanupHook() {
        Runtime.getRuntime().removeShutdownHook(this);
    }

    public void cleanup() throws IOException {
        if (!this.done) {
            System.setProperty("user.dir", this.origin.toString());
            if (this.basePath != null) {
                Files.walkFileTree(this.basePath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            this.done = true;
        }
    }

    public Path getBasePath() {
        return this.basePath;
    }
}

