/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util;

import ch.icosys.popjava.core.annotation.POPParameter;
import ch.icosys.popjava.core.system.POPJavaConfiguration;
import ch.icosys.popjava.core.system.POPSystem;
import java.lang.annotation.Annotation;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URLClassLoader;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Util {
    private static final Random RANDOM = new SecureRandom();
    public static Set<URLClassLoader> urlClassloaders = Collections.synchronizedSet(new HashSet());

    public static boolean sameContact(String source, String dest) {
        String[] allDestHost;
        if (source == null || source.isEmpty() || dest == null || dest.isEmpty()) {
            return false;
        }
        if (source.compareTo(dest) == 0) {
            return true;
        }
        for (String str : allDestHost = dest.split("[ \t\r\n]")) {
            if (!source.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isLocal(String hostname) {
        if (hostname == null || hostname.length() == 0 || hostname.equals("localhost") || hostname.equals("127.0.0.1") || hostname.equals("0.0.0.0") || hostname.equals("127.0.1.1")) {
            return true;
        }
        if (Util.sameContact(POPSystem.getHostIP().getAddress().getHostAddress(), hostname)) {
            return true;
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                InterfaceAddress ip = POPSystem.getInterfaceIP(ni, true);
                if (ip == null || !ip.getAddress().getHostAddress().equals(hostname)) continue;
                return true;
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return false;
    }

    public static String removeStringFromList(List<String> list, String prefix) {
        String result = null;
        int index = 0;
        for (index = 0; index < list.size(); ++index) {
            String str = list.get(index);
            if (!str.startsWith(prefix)) continue;
            result = str.substring(prefix.length());
            list.remove(index);
            break;
        }
        return result;
    }

    public static boolean isStringEqual(String s1, String s2) {
        return s1 != null && s2 != null && s1.equals(s2);
    }

    public static boolean isNoCaseStringEqual(String s1, String s2) {
        return s1 != null && s2 != null && s1.equalsIgnoreCase(s2);
    }

    public static String join(String delimiter, String ... join) {
        Objects.requireNonNull(join);
        StringBuilder sb = null;
        for (String s : join) {
            if (sb != null) {
                sb.append(delimiter);
            } else {
                sb = new StringBuilder();
            }
            sb.append(s);
        }
        return sb != null ? sb.toString() : null;
    }

    public static String join(String delimiter, List<String> join) {
        return Util.join(delimiter, join.toArray(new String[join.size()]));
    }

    public static String generateRandomString(int length) {
        StringBuilder result = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int randomInt = RANDOM.nextInt() & Integer.MAX_VALUE;
            randomInt = (int)((float)randomInt / 2.1474836E9f * 24.0f + 65.0f);
            result.append((char)randomInt);
        }
        return result.toString();
    }

    public static String generateUUID() {
        return UUID.randomUUID().toString();
    }

    public static ArrayList<String> splitTheCommand(String command) {
        return new ArrayList<String>(Arrays.asList(command.trim().split(" ")));
    }

    public static boolean matchPlatform(String parent, String child) {
        String regex = parent.replaceAll("\\*", ".+");
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(child);
        return m.find() && m.start() == 0 && m.end() == child.length();
    }

    public static int byteArrayToInt(byte[] value) {
        return value[0] << 24 | (value[1] & 0xFF) << 16 | (value[2] & 0xFF) << 8 | value[3] & 0xFF;
    }

    public static boolean isParameterNotOfDirection(Annotation[] annotations, POPParameter.Direction direction) {
        for (Annotation annotation : annotations) {
            POPParameter popParameter;
            if (annotation.annotationType() != POPParameter.class || (popParameter = (POPParameter)annotation).value() != direction) continue;
            return false;
        }
        return true;
    }

    public static boolean isParameterOfAnyDirection(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType() != POPParameter.class) continue;
            return true;
        }
        return false;
    }

    public static boolean isParameterUsable(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            POPParameter popParameter;
            if (annotation.annotationType() != POPParameter.class || (popParameter = (POPParameter)annotation).value() != POPParameter.Direction.IGNORE) continue;
            return false;
        }
        return true;
    }

    public static OSType getOSType() {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            return OSType.Windows;
        }
        return OSType.UNIX;
    }

    public static String getLocalJavaFileLocation(String objname) {
        String codePath = null;
        try {
            Class<?> javaClass = Util.getClass(objname);
            codePath = String.format(POPJavaConfiguration.getBrokerCommand(), POPJavaConfiguration.getPopJavaJar(), POPJavaConfiguration.getClassPath()) + javaClass.getProtectionDomain().getCodeSource().getLocation().getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return codePath;
    }

    private static Class<?> getClass(String objname) throws ClassNotFoundException {
        try {
            ClassLoader classloader = new Util().getClass().getClassLoader();
            Class<?> javaClass = classloader.loadClass(objname);
            return javaClass;
        }
        catch (Exception exception) {
            for (URLClassLoader classloader : urlClassloaders) {
                try {
                    Class<?> javaClass = classloader.loadClass(objname);
                    return javaClass;
                }
                catch (Exception exception2) {
                }
            }
            throw new ClassNotFoundException(objname);
        }
    }

    public static enum OSType {
        UNIX,
        Windows;

    }
}

