/*
 * Decompiled with CFR 0.152.
 */
package ch.icosys.popjava.core.util;

import ch.icosys.popjava.core.util.LogWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class WatchDirectory
implements Runnable {
    public static final WatchMethod EMPTY = new WatchMethod();
    private Path watchedDir;
    private WatchService watcher;
    private WatchMethod method;
    private boolean running = true;

    public WatchDirectory(Path path, WatchMethod method, WatchEvent.Kind ... eventsKind) {
        if (eventsKind.length == 0) {
            eventsKind = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
        }
        try {
            this.watchedDir = path;
            this.watcher = this.watchedDir.getFileSystem().newWatchService();
            this.watchedDir.register(this.watcher, eventsKind);
            this.method = method;
            LogWriter.writeDebugInfo("[WatchDirectory] Watching '%s'.", path);
        }
        catch (Exception e) {
            this.running = false;
            LogWriter.writeDebugInfo("[WatchDirectory] Failed to start watcher services: %s", e.getMessage());
        }
    }

    public Path getWatchedDir() {
        return this.watchedDir;
    }

    @Override
    public void run() {
        try {
            while (this.running) {
                WatchKey watchKey = this.watcher.take();
                List<WatchEvent<?>> events = watchKey.pollEvents();
                for (WatchEvent<?> event : events) {
                    if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                        this.method.create(event.context().toString());
                        continue;
                    }
                    if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                        this.method.delete(event.context().toString());
                        continue;
                    }
                    if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY) continue;
                    this.method.modify(event.context().toString());
                }
                watchKey.reset();
            }
        }
        catch (Exception e) {
            LogWriter.writeDebugInfo("[WatchDirectory] Error: " + e.toString());
        }
    }

    public void stop() {
        this.running = false;
        this.method = EMPTY;
        try {
            LogWriter.writeDebugInfo("[WatchDirectory] Stopped watching '%s'.", this.watchedDir.toString());
            Path stopWatcher = Files.createTempFile(this.watchedDir, "stopwatcher.", ".tmp", new FileAttribute[0]);
            Files.deleteIfExists(stopWatcher);
        }
        catch (IOException e) {
            LogWriter.writeDebugInfo("[WatchDirectory] Thread may have not stopped correctly: %s", e.toString());
        }
    }

    public static class WatchMethod {
        public void create(String s) {
        }

        public void delete(String s) {
        }

        public void modify(String s) {
        }
    }
}

