/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.asciidoctor.gherkin;

import ch.ifocusit.asciidoctor.gherkin.GherkinExtensionHelper;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;

public class GherkinAsciidocBuilder {
    private String featureContent;
    private String templateContent = GherkinExtensionHelper.getDefaultTemplate();
    private boolean withTitle = true;
    private boolean withKeyword = false;
    private boolean withChildSeparator = false;

    public static GherkinAsciidocBuilder builder() {
        return new GherkinAsciidocBuilder();
    }

    public String build() {
        ScriptingContainer container = new ScriptingContainer(LocalContextScope.SINGLETON);
        container.put("withTitle", (Object)this.withTitle);
        container.put("withKeyword", (Object)this.withKeyword);
        container.put("withChildSeparator", (Object)this.withChildSeparator);
        container.put("feature", (Object)GherkinExtensionHelper.parse(this.featureContent));
        container.put("template_content", (Object)this.templateContent);
        String result = (String)container.runScriptlet("require('erb')\nerb = ERB.new(template_content, trim_mode: \"<>\")\nasciidoc = erb.result(binding)\nasciidoc\n");
        return result;
    }

    public String featureContent() {
        return this.featureContent;
    }

    public String templateContent() {
        return this.templateContent;
    }

    public boolean withTitle() {
        return this.withTitle;
    }

    public boolean withKeyword() {
        return this.withKeyword;
    }

    public boolean withChildSeparator() {
        return this.withChildSeparator;
    }

    public GherkinAsciidocBuilder featureContent(String featureContent) {
        this.featureContent = featureContent;
        return this;
    }

    public GherkinAsciidocBuilder templateContent(String templateContent) {
        this.templateContent = templateContent;
        return this;
    }

    public GherkinAsciidocBuilder withTitle(boolean withTitle) {
        this.withTitle = withTitle;
        return this;
    }

    public GherkinAsciidocBuilder withKeyword(boolean withKeyword) {
        this.withKeyword = withKeyword;
        return this;
    }

    public GherkinAsciidocBuilder withChildSeparator(boolean withChildSeparator) {
        this.withChildSeparator = withChildSeparator;
        return this;
    }
}

