/*
 * Gherkin Asciidoctor Extension
 *
 * Copyright (C) 2024 Focus IT
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package ch.ifocusit.asciidoctor.gherkin;

import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;

import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

@Getter
@Setter
@Accessors(chain = true, fluent = true)
public class GherkinAsciidocBuilder {

    private String featureContent;
    private String templateContent = GherkinExtensionHelper.getDefaultTemplate();

    // # tag::attributs[]
    private boolean withTitle = true;
    private boolean withKeyword = false;
    private boolean withChildSeparator = false;
    // # end::attributs[]

    public static GherkinAsciidocBuilder builder() {
        return new GherkinAsciidocBuilder();
    }

    public String build() {
        ScriptingContainer container = new ScriptingContainer(LocalContextScope.SINGLETON);

        container.put("withTitle", withTitle);
        container.put("withKeyword", withKeyword);
        container.put("withChildSeparator", withChildSeparator);
        container.put("feature", GherkinExtensionHelper.parse(featureContent));
        container.put("template_content", templateContent);

        String result = (String) container.runScriptlet("require('erb')\n" +
                "erb = ERB.new(template_content, trim_mode: \"<>\")\n" +
                "asciidoc = erb.result(binding)\n" +
                "asciidoc\n");

        return result;
    }
}
