/*
 * Gherkin Asciidoctor Extension
 *
 * Copyright (C) 2024 Focus IT
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package ch.ifocusit.asciidoctor.gherkin;

import static io.cucumber.messages.types.SourceMediaType.TEXT_X_CUCUMBER_GHERKIN_PLAIN;

import java.nio.file.Path;

import org.apache.commons.io.IOUtils;

import io.cucumber.gherkin.GherkinParser;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Source;
import lombok.SneakyThrows;

public class GherkinExtensionHelper {

    @SneakyThrows
    public static String getPath() {
        return Path.of(GherkinExtensionHelper.class.getResource("default_template.erb").toURI()).getParent().toString();
    }

    @SneakyThrows
    public static String getDefaultTemplate() {
        return IOUtils.toString(GherkinExtensionHelper.class.getResourceAsStream("default_template.erb"), "utf-8");
    }

    @SneakyThrows
    public static Feature parse(String content) {
        Feature feature = GherkinParser.builder()
                .includeSource(false)
                .includePickles(false)
                .build()
                .parse(Envelope.of(new Source("feature", content, TEXT_X_CUCUMBER_GHERKIN_PLAIN)))
                .findFirst().get()
                .getGherkinDocument().get()
                .getFeature().get();
        return feature;
    }
}
