# /*
#  * Gherkin Asciidoctor Extension
#  *
#  * Copyright (C) 2024 Focus IT
#  *
#  * Licensed to the Apache Software Foundation (ASF) under one
#  * or more contributor license agreements.  See the NOTICE file
#  * distributed with this work for additional information
#  * regarding copyright ownership.  The ASF licenses this file
#  * to you under the Apache License, Version 2.0 (the
#  * "License"); you may not use this file except in compliance
#  * with the License.  You may obtain a copy of the License at
#  *
#  *   http://www.apache.org/licenses/LICENSE-2.0
#  *
#  * Unless required by applicable law or agreed to in writing,
#  * software distributed under the License is distributed on an
#  * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
#  * KIND, either express or implied.  See the License for the
#  * specific language governing permissions and limitations
#  * under the License.
#  */
#A block macro processor converting gherkin feature files to asciidoctor markup
require 'asciidoctor'
require 'asciidoctor/extensions'
require 'erb'
require 'java'

java_import 'ch.ifocusit.asciidoctor.gherkin.GherkinExtensionHelper'

class String
  def to_b
    self.downcase == 'true'
  end
end

class GherkinBlockMacroProcessor < Asciidoctor::Extensions::BlockMacroProcessor
  use_dsl
	
  named :gherkin
  name_positional_attributes 'template'

  def process parent, target, attributes
    doc = parent.document
    reader = parent.document.reader

    feature_file_name = target
    if doc.attributes.key?('docdir') 
    	feature_file_name = File.expand_path(feature_file_name, doc.attributes['docdir'])
    end
    
    if attributes.key?("encoding")
    	encoding = attributes["encoding"]
    elsif doc.attributes.key?("encoding")
    	encoding = doc.attributes["encoding"]
    else
    	encoding = "UTF-8"
    end
    
    if doc.attributes.key?('docdir') && attributes.key?('template') && File.exist?(File.expand_path(attributes['template'], doc.attributes['docdir']))
    	template_file = File.open(File.expand_path(attributes['template'], doc.attributes['docdir']), "rb", :encoding => "utf-8")
    	template_content = template_file.read 
    else
      template_content = GherkinExtensionHelper.getDefaultTemplate()
    end
    
    file = File.open(feature_file_name, "rb", :encoding => encoding)
    feature_file_content = file.read

    withTitle = attributes.key?('withTitle') ? attributes["withTitle"]&.to_b : true
    withKeyword = attributes["withKeyword"]&.to_b
    withChildSeparator = attributes["withChildSeparator"]&.to_b
    feature = GherkinExtensionHelper.parse(feature_file_content)

    erb_template = ERB.new(template_content, trim_mode: "<>")
    
    rendered_template_output = erb_template.result(binding)

    reader.push_include rendered_template_output, target, target, 1, attributes
    nil
  end
end
