/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.CommonMojoDefinition;
import ch.ifocusit.livingdoc.plugin.common.ClassLoaderUtil;
import ch.ifocusit.livingdoc.plugin.mapping.MappingDefinition;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.simpleflatmapper.csv.CsvParser;

public abstract class CommonGlossaryMojoDefinition
extends CommonMojoDefinition {
    @Parameter(defaultValue="${project.build.sourceDirectory}")
    private List<String> sources;
    @Parameter(defaultValue="Glossary")
    private String annotation;
    @Parameter
    private File glossaryMapping;
    @Parameter
    private String packageRoot;
    protected AsciiDocBuilder asciiDocBuilder = new AsciiDocBuilder();
    protected JavaProjectBuilder javaDocBuilder;
    protected List<MappingDefinition> mappings;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.javaDocBuilder = this.buildJavaProjectBuilder();
        if (CommonMojoDefinition.Format.html.equals((Object)this.format)) {
            this.asciiDocBuilder.sectionTitleLevel1(this.getTitle());
        }
        if (this.glossaryMapping != null) {
            try {
                this.mappings = CsvParser.mapTo(MappingDefinition.class).stream((Reader)new FileReader(this.glossaryMapping)).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new MojoExecutionException("error reading mappings file", (Exception)e);
            }
        }
        this.executeMojo();
        this.write(this.asciiDocBuilder);
    }

    protected abstract String getTitle();

    protected abstract void executeMojo();

    protected Stream<JavaClass> getClasses() {
        return this.javaDocBuilder.getClasses().stream().filter(javaClass -> this.packageRoot == null || javaClass.getPackageName().startsWith(this.packageRoot)).filter(this::hasAnnotation);
    }

    protected boolean hasAnnotation(JavaAnnotatedElement annotatedElement) {
        return this.getGlossary(annotatedElement).isPresent();
    }

    protected Optional<JavaAnnotation> getGlossary(JavaAnnotatedElement annotatedElement) {
        return annotatedElement.getAnnotations().stream().filter(a -> a.getType().getFullyQualifiedName().endsWith(this.annotation)).findFirst();
    }

    protected Optional<Integer> getGlossaryId(JavaAnnotatedElement annotatedElement) {
        Optional<JavaAnnotation> annotation = this.getGlossary(annotatedElement);
        return annotation.map(annot -> annot.getProperty("id") == null ? null : Optional.ofNullable(Integer.valueOf(String.valueOf(annot.getNamedParameter("id"))))).orElse(Optional.empty());
    }

    protected Optional<MappingDefinition> getDefinition(Optional<Integer> id) {
        return this.mappings == null || !id.isPresent() ? Optional.empty() : this.mappings.stream().filter(def -> ((Integer)id.get()).equals(def.getId())).findFirst();
    }

    protected String getName(JavaAnnotatedElement annotatedElement, String defaultValue) {
        return this.getDefinition(this.getGlossaryId(annotatedElement)).map(def -> def.getName()).orElse(defaultValue);
    }

    protected String getDescription(JavaAnnotatedElement annotatedElemen, String defaultValue) {
        return this.getDefinition(this.getGlossaryId(annotatedElemen)).map(def -> def.getDescription()).orElse(defaultValue);
    }

    protected MappingDefinition map(JavaAnnotatedElement annotatedElement, String name, String comment) {
        MappingDefinition def = new MappingDefinition();
        def.setId(this.getGlossaryId(annotatedElement).orElse(null));
        def.setName(this.getName(annotatedElement, name));
        def.setDescription(this.getDescription(annotatedElement, comment));
        return def;
    }

    private JavaProjectBuilder buildJavaProjectBuilder() throws MojoExecutionException {
        JavaProjectBuilder javaDocBuilder = new JavaProjectBuilder();
        javaDocBuilder.setEncoding(Charset.defaultCharset().toString());
        javaDocBuilder.setErrorHandler(e -> this.getLog().warn((CharSequence)e.getMessage()));
        this.sources.stream().map(File::new).forEach(arg_0 -> ((JavaProjectBuilder)javaDocBuilder).addSourceTree(arg_0));
        javaDocBuilder.addClassLoader(ClassLoaderUtil.getRuntimeClassLoader(this.project));
        this.loadSourcesDependencies(javaDocBuilder);
        return javaDocBuilder;
    }

    private void loadSourcesDependencies(JavaProjectBuilder javaDocBuilder) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
        Stream.concat(this.project.getDependencies().stream(), this.project.getPlugin(pluginDescriptor.getPluginLookupKey()).getDependencies().stream()).forEach(dependency -> {
            Artifact sourcesArtifact = this.repositorySystem.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), "sources");
            this.loadSourcesDependency(javaDocBuilder, sourcesArtifact);
        });
    }

    private void loadSourcesDependency(JavaProjectBuilder javaDocBuilder, Artifact sourcesArtifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(sourcesArtifact);
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        result.getArtifacts().forEach(artifact -> {
            try {
                JarFile jarFile = new JarFile(artifact.getFile());
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".java") || name.endsWith("/package-info.java")) continue;
                    javaDocBuilder.addSource(new URL("jar:" + artifact.getFile().toURI().toURL().toString() + "!/" + name));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Unable to load jar source " + artifact), (Throwable)e);
            }
        });
    }

    private static Function<MappingDefinition, ?> key() {
        return def -> def.getId() == null ? def.getName().toLowerCase() : def.getId();
    }

    protected static Predicate<MappingDefinition> distinctByKey() {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(CommonGlossaryMojoDefinition.key().apply((MappingDefinition)t), Boolean.TRUE) == null;
    }

    protected String defaultString(Integer id, String defaultString) {
        return id == null ? defaultString : String.valueOf(id);
    }

    protected String idFromName(MappingDefinition def) {
        return def.getName().replaceAll(" ", "");
    }
}

