/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.diagram;

import ch.ifocusit.livingdoc.plugin.common.ClassLoaderUtil;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Predicate;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractClassDiagramBuilder {
    private static final String TEST = "Test";
    private static final String PACKAGE_INFO = "package-info";
    private final String IT = "IT";
    protected final MavenProject project;
    protected final String prefix;
    protected final String[] excludes;
    protected final File header;
    protected final File footer;

    public AbstractClassDiagramBuilder(MavenProject project, String prefix, String[] excludes, File header, File footer) {
        this.project = project;
        this.prefix = prefix;
        this.excludes = excludes;
        this.header = header;
        this.footer = footer;
    }

    public abstract AbstractClassDiagramBuilder filterOnAnnotation(Class<? extends Annotation> var1);

    public abstract String generate() throws MojoExecutionException;

    protected String readHeader() throws MojoExecutionException {
        return this.read(this.header);
    }

    protected String readFooter() throws MojoExecutionException {
        return this.read(this.footer);
    }

    protected String read(File file) throws MojoExecutionException {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            return IOUtils.toString((URI)file.toURI(), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read header file !", (Exception)e);
        }
    }

    protected Predicate<ClassPath.ClassInfo> defaultFilter() {
        return ci -> ci.getPackageName().startsWith(this.prefix) && !ci.getSimpleName().equalsIgnoreCase(PACKAGE_INFO) && !ci.getSimpleName().endsWith(TEST) && !ci.getSimpleName().endsWith("IT") && Arrays.stream(this.excludes).noneMatch(excl -> ci.getName().matches((String)excl));
    }

    protected ClassPath initClassPath() throws MojoExecutionException {
        try {
            return ClassPath.from((ClassLoader)ClassLoaderUtil.getRuntimeClassLoader(this.project));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to initialize classPath !", (Exception)e);
        }
    }
}

