/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.diagram;

import ch.ifocusit.livingdoc.annotations.RootAggregate;
import ch.ifocusit.livingdoc.plugin.AnnotationUtils;
import ch.ifocusit.livingdoc.plugin.diagram.AbstractClassDiagramBuilder;
import ch.ifocusit.livingdoc.plugin.domain.Color;
import ch.ifocusit.livingdoc.plugin.mapping.GlossaryNamesMapper;
import ch.ifocusit.plantuml.classdiagram.ClassDiagramBuilder;
import ch.ifocusit.plantuml.classdiagram.NamesMapper;
import ch.ifocusit.plantuml.classdiagram.model.clazz.JavaClazz;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public class PlantumlClassDiagramBuilder
extends AbstractClassDiagramBuilder {
    private ClassDiagramBuilder classDiagramBuilder;
    private Predicate<ClassPath.ClassInfo> additionalClassPredicate = a -> true;
    private GlossaryNamesMapper namesMapper;

    public PlantumlClassDiagramBuilder(MavenProject project, String prefix, String[] excludes, final Color rootAggregateColor, File header, File footer) {
        super(project, prefix, excludes, header, footer);
        this.classDiagramBuilder = new ClassDiagramBuilder(){

            protected JavaClazz createJavaClass(Class clazz) {
                JavaClazz javaClass = super.createJavaClass(clazz);
                if (rootAggregateColor != null) {
                    AnnotationUtils.tryFind(clazz, RootAggregate.class).ifPresent(annot -> javaClass.setBackgroundColor(rootAggregateColor.getBackgroundColor()).setBorderColor(rootAggregateColor.getBorderColor()));
                }
                return javaClass;
            }
        };
    }

    @Override
    public String generate() throws MojoExecutionException {
        ClassPath classPath = this.initClassPath();
        ImmutableSet allClasses = classPath.getTopLevelClassesRecursive(this.prefix);
        if (this.namesMapper != null) {
            this.classDiagramBuilder.withNamesMapper((NamesMapper)this.namesMapper);
        }
        String diagram = this.classDiagramBuilder.addClasse((Iterable)allClasses.stream().filter(this.defaultFilter()).filter(this.additionalClassPredicate).map(ClassPath.ClassInfo::load).collect(Collectors.toList())).excludes(this.excludes).setHeader(this.readHeader()).setFooter(this.readFooter()).build();
        return diagram;
    }

    @Override
    public PlantumlClassDiagramBuilder filterOnAnnotation(Class<? extends Annotation> annotation) {
        this.additionalClassPredicate = this.additionalClassPredicate.and(classInfo -> classInfo.load().isAnnotationPresent(annotation));
        this.classDiagramBuilder.addFieldPredicate(attribut -> attribut.getField().isAnnotationPresent(annotation));
        return this;
    }

    public void mapNames(File mappings, Class<? extends Annotation> annotation, String linkTemplate) throws MojoExecutionException {
        try {
            this.namesMapper = new GlossaryNamesMapper<Annotation>(mappings, annotation, linkTemplate);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error reading mappings file", (Exception)e);
        }
    }
}

