/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.mapping;

import ch.ifocusit.livingdoc.annotations.UbiquitousLanguage;
import ch.ifocusit.livingdoc.plugin.AnnotationUtils;
import ch.ifocusit.livingdoc.plugin.mapping.MappingDefinition;
import ch.ifocusit.plantuml.classdiagram.NamesMapper;
import ch.ifocusit.plantuml.classdiagram.model.Link;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.simpleflatmapper.csv.CsvParser;

public class GlossaryNamesMapper<A extends UbiquitousLanguage>
implements NamesMapper {
    List<MappingDefinition> mappings = new ArrayList<MappingDefinition>();
    private Class<A> annotation;
    private String linkTemplate;

    public GlossaryNamesMapper(File file, Class<A> annotation, String linkTemplate) throws IOException {
        this.annotation = annotation;
        this.linkTemplate = linkTemplate;
        if (file != null) {
            this.mappings = CsvParser.mapTo(MappingDefinition.class).stream((Reader)new FileReader(file)).collect(Collectors.toList());
        }
    }

    private Optional<String> getName(int id) {
        return this.mappings.stream().filter(def -> def.getId() == id).findFirst().map(MappingDefinition::getName);
    }

    public String getClassName(Class aClass) {
        int id = AnnotationUtils.tryFind(aClass, this.annotation).map(UbiquitousLanguage::id).orElse(-1);
        return this.getName(id).orElse(super.getClassName(aClass));
    }

    public Optional<Link> getClassLink(Class aClass) {
        return Optional.of(this.create(this.getClassName(aClass), AnnotationUtils.tryFind(aClass, this.annotation)));
    }

    public String getFieldName(Field field) {
        int id = AnnotationUtils.tryFind(field, this.annotation).map(UbiquitousLanguage::id).orElse(-1);
        return this.getName(id).orElse(super.getFieldName(field));
    }

    public Optional<Link> getFieldLink(Field field) {
        return Optional.of(this.create(this.getFieldName(field), AnnotationUtils.tryFind(field, this.annotation)));
    }

    private Link create(String name, Optional<A> annotation) {
        Link link = new Link();
        link.setLabel(name);
        String anchor = annotation.map(annot -> annot.id() == -1 ? this.linkFromName(name) : String.valueOf(annot.id())).orElse(this.linkFromName(name));
        link.setUrl(MessageFormat.format(this.linkTemplate, anchor));
        return link;
    }

    private String linkFromName(String name) {
        return name.replaceAll(" ", "");
    }
}

