/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractDocsGeneratorMojo;
import com.github.domgold.doctools.asciidoctor.gherkin.MapFormatter;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="gherkin", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class GherkinMojo
extends AbstractDocsGeneratorMojo {
    @Parameter(property="livingdoc.gherkin.features", defaultValue="${project.basedir}/src/test/resources/features")
    private List<String> features;
    @Parameter(property="livingdoc.gherkin.options")
    private String gherkinOptions;
    @Parameter(property="livingdoc.gherkin.output.filename", defaultValue="gherkin", required=true)
    private String gherkinOutputFilename;
    @Parameter(property="livingdoc.gherkin.title")
    private String gherkinTitle;
    @Parameter(property="livingdoc.gherkin.separate", defaultValue="false")
    private boolean gerkinSeparateFeature;
    protected boolean somethingWasGenerated = false;
    private List<AsciiDocBuilder> docBuilders = new ArrayList<AsciiDocBuilder>();
    private AtomicInteger pageCount = new AtomicInteger(0);

    @Override
    protected String getOutputFilename() {
        return this.gherkinOutputFilename;
    }

    @Override
    protected String getTitle() {
        return this.gherkinTitle;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.gerkinSeparateFeature) {
            this.appendTitle(this.get(this.pageCount.get()));
        }
        this.readFeatures().forEach(path -> {
            if (this.gerkinSeparateFeature) {
                try {
                    Map parsed = MapFormatter.parse((String)FileUtils.readFileToString((File)FileUtils.getFile((String[])new String[]{path}), (Charset)Charset.defaultCharset()));
                    String title = StringUtils.defaultString((String)this.getTitle(), (String)"") + String.valueOf(parsed.get("name"));
                    this.appendTitle(this.get(this.pageCount.get()), title);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Error reading " + path, e);
                }
            }
            this.get(this.pageCount.get()).textLine(String.format("gherkin::%s[%s]", path, this.gherkinOptions));
            this.get(this.pageCount.get()).textLine("");
            this.somethingWasGenerated = true;
            if (this.gerkinSeparateFeature) {
                this.pageCount.incrementAndGet();
            }
        });
        if (!this.somethingWasGenerated) {
            return;
        }
        this.write(this.docBuilders.get(0));
    }

    private AsciiDocBuilder get(int index) {
        if (this.docBuilders.size() <= index) {
            this.docBuilders.add(this.createAsciiDocBuilder());
        }
        return this.docBuilders.get(index);
    }

    private Stream<String> readFeatures() {
        return this.features.stream().filter(path -> Files.exists(Paths.get(path, new String[0]), new LinkOption[0])).flatMap(path -> {
            try {
                return Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(p -> p.toString().endsWith(".feature"));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error browsing %s", path), e);
            }
        }).map(Path::toString);
    }
}

