/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.baseMojo;

import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractAsciidoctorMojo;
import io.github.robwin.markup.builder.asciidoc.AsciiDoc;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.repository.RepositorySystem;

public abstract class AbstractDocsGeneratorMojo
extends AbstractAsciidoctorMojo {
    private static final String TITLE_MARKUP = AsciiDoc.DOCUMENT_TITLE.toString();
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(property="livingdoc.diagram.output.format", defaultValue="html")
    protected AbstractAsciidoctorMojo.Format format;
    @Parameter(property="livingdoc.diagram.glossary.mapping")
    protected File glossaryMapping;
    @Parameter(property="livingdoc.diagram.onlyAnnotated", defaultValue="false")
    protected boolean onlyAnnotated;

    protected abstract String getOutputFilename();

    protected abstract String getTitle();

    protected void write(String newContent, File output) throws MojoExecutionException {
        try {
            output.getParentFile().mkdirs();
            IOUtils.write((String)newContent, (OutputStream)new FileOutputStream(output), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to write output file '%s' !", output), (Exception)e);
        }
    }

    protected void write(AsciiDocBuilder asciiDocBuilder) throws MojoExecutionException {
        this.write(asciiDocBuilder, this.getOutputFilename());
    }

    protected void write(AsciiDocBuilder asciiDocBuilder, String outputFilename) throws MojoExecutionException {
        this.write(asciiDocBuilder, this.format, outputFilename);
    }

    protected AsciiDocBuilder createAsciiDocBuilder() {
        AsciiDocBuilder asciiDocBuilder = new AsciiDocBuilder();
        asciiDocBuilder.textLine(":sectlinks:");
        asciiDocBuilder.textLine(":sectanchors:");
        return asciiDocBuilder;
    }

    protected void appendTitle(AsciiDocBuilder asciiDocBuilder) {
        String definedTitle = this.getTitle();
        if (StringUtils.isNotBlank((CharSequence)definedTitle)) {
            String title = definedTitle.startsWith(TITLE_MARKUP) ? definedTitle : TITLE_MARKUP + definedTitle;
            this.appendTitle(asciiDocBuilder, title);
        }
    }

    protected void appendTitle(AsciiDocBuilder asciiDocBuilder, String title) {
        asciiDocBuilder.textLine(title).newLine();
    }
}

