/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.baseMojo;

import ch.ifocusit.livingdoc.annotations.UbiquitousLanguage;
import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractDocsGeneratorMojo;
import ch.ifocusit.livingdoc.plugin.mapping.DomainObject;
import ch.ifocusit.livingdoc.plugin.mapping.MappingRespository;
import ch.ifocusit.livingdoc.plugin.utils.ClassLoaderUtil;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Parameter;
import org.simpleflatmapper.csv.CsvParser;

public abstract class AbstractGlossaryMojo
extends AbstractDocsGeneratorMojo
implements MappingRespository {
    protected static final String JAVAX_VALIDATION_CONSTRAINTS = "javax.validation.constraints.";
    protected static final String HIBERNATE_VALIDATION_CONSTRAINTS = "org.hibernate.validator.constraints.";
    @Parameter(property="livingdoc.glossary.sources", defaultValue="${project.build.sourceDirectory}")
    private List<String> sources = new ArrayList<String>();
    @Parameter(property="livingdoc.glossary.packageRoot", defaultValue="${project.groupId}.${project.artifactId}.domain")
    private String packageRoot;
    @Parameter
    private String[] excludes = new String[0];
    protected AsciiDocBuilder asciiDocBuilder = this.createAsciiDocBuilder();
    protected JavaProjectBuilder javaDocBuilder;
    protected List<DomainObject> mappings;
    protected boolean somethingWasGenerated = false;
    private static final String TEST = "Test";
    private static final String IT = "IT";
    private static final String PACKAGE_INFO = "package-info";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.javaDocBuilder = this.buildJavaProjectBuilder();
        this.appendTitle(this.asciiDocBuilder);
        if (this.glossaryMapping != null) {
            try {
                this.mappings = CsvParser.mapTo(DomainObject.class).stream((Reader)new FileReader(this.glossaryMapping)).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new MojoExecutionException("error reading mappings file", (Exception)e);
            }
        }
        try {
            this.executeMojo();
        }
        catch (Exception e) {
            throw new MojoExecutionException("error executing glossary template", e);
        }
        if (!this.somethingWasGenerated) {
            return;
        }
        this.write(this.asciiDocBuilder);
    }

    @Override
    protected abstract String getTitle();

    protected abstract void executeMojo() throws Exception;

    protected Stream<JavaClass> getClasses() {
        return this.javaDocBuilder.getClasses().stream().filter(javaClass -> this.packageRoot == null || javaClass.getPackageName().startsWith(this.packageRoot)).filter(this::hasAnnotation).filter(this.defaultFilter());
    }

    protected Predicate<JavaClass> defaultFilter() {
        return ci -> !ci.getSimpleName().equalsIgnoreCase(PACKAGE_INFO) && !ci.getSimpleName().endsWith(TEST) && !ci.getSimpleName().endsWith(IT) && Arrays.stream(this.excludes).noneMatch(excl -> ci.getCanonicalName().matches((String)excl));
    }

    protected boolean hasAnnotation(JavaAnnotatedElement annotatedElement) {
        return !this.onlyAnnotated || this.getGlossary(annotatedElement).isPresent();
    }

    private Optional<JavaAnnotation> getGlossary(JavaAnnotatedElement annotatedElement) {
        return annotatedElement.getAnnotations().stream().filter(a -> a.getType().getFullyQualifiedName().endsWith(UbiquitousLanguage.class.getSimpleName())).findFirst();
    }

    private Optional<Integer> getGlossaryId(JavaAnnotatedElement annotatedElement) {
        Optional<JavaAnnotation> annotation = this.getGlossary(annotatedElement);
        return annotation.map(annot -> annot.getProperty("id") == null ? null : Optional.ofNullable(Integer.valueOf(String.valueOf(annot.getNamedParameter("id"))))).orElse(Optional.empty());
    }

    @Override
    public Optional<DomainObject> getMapping(JavaAnnotatedElement annotatedElement) {
        Optional<Integer> id = this.getGlossaryId(annotatedElement);
        return this.mappings == null || !id.isPresent() ? Optional.empty() : this.mappings.stream().filter(def -> ((Integer)id.get()).equals(def.getId())).findFirst();
    }

    private JavaProjectBuilder buildJavaProjectBuilder() throws MojoExecutionException {
        JavaProjectBuilder javaDocBuilder = new JavaProjectBuilder();
        javaDocBuilder.setEncoding(Charset.defaultCharset().toString());
        javaDocBuilder.setErrorHandler(e -> this.getLog().warn((CharSequence)e.getMessage()));
        this.sources.stream().map(File::new).forEach(arg_0 -> ((JavaProjectBuilder)javaDocBuilder).addSourceTree(arg_0));
        javaDocBuilder.addClassLoader(ClassLoaderUtil.getRuntimeClassLoader(this.project));
        this.loadSourcesDependencies(javaDocBuilder);
        return javaDocBuilder;
    }

    private void loadSourcesDependencies(JavaProjectBuilder javaDocBuilder) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
        Stream.concat(this.project.getDependencies().stream(), this.project.getPlugin(pluginDescriptor.getPluginLookupKey()).getDependencies().stream()).forEach(dependency -> {
            Artifact sourcesArtifact = this.repositorySystem.createArtifactWithClassifier(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getType(), "sources");
            this.loadSourcesDependency(javaDocBuilder, sourcesArtifact);
        });
    }

    private void loadSourcesDependency(JavaProjectBuilder javaDocBuilder, Artifact sourcesArtifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest();
        request.setArtifact(sourcesArtifact);
        ArtifactResolutionResult result = this.repositorySystem.resolve(request);
        result.getArtifacts().forEach(artifact -> {
            try {
                JarFile jarFile = new JarFile(artifact.getFile());
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.endsWith(".java") || name.endsWith("/package-info.java")) continue;
                    javaDocBuilder.addSource(new URL("jar:" + artifact.getFile().toURI().toURL().toString() + "!/" + name));
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Unable to load jar source " + artifact + " : " + e.getMessage()));
            }
        });
    }
}

