/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.diagram;

import ch.ifocusit.livingdoc.annotations.UbiquitousLanguage;
import ch.ifocusit.livingdoc.plugin.mapping.GlossaryNamesMapper;
import ch.ifocusit.livingdoc.plugin.utils.AnchorUtil;
import ch.ifocusit.livingdoc.plugin.utils.AnnotationUtil;
import ch.ifocusit.livingdoc.plugin.utils.ClassLoaderUtil;
import ch.ifocusit.livingdoc.plugin.utils.FileUtils;
import ch.ifocusit.plantuml.classdiagram.LinkMaker;
import ch.ifocusit.plantuml.classdiagram.NamesMapper;
import ch.ifocusit.plantuml.classdiagram.model.Link;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;

public abstract class AbstractClassDiagramBuilder
implements LinkMaker,
NamesMapper {
    private static final String TEST = "Test";
    private static final String IT = "IT";
    private static final String PACKAGE_INFO = "package-info";
    protected final MavenProject project;
    protected final String prefix;
    protected final String[] excludes;
    protected final File header;
    protected final File footer;
    protected final boolean diagramWithDependencies;
    protected String linkPage;
    protected NamesMapper namesMapper = this;
    private Class<? extends Annotation> mappingAnnotation;

    public AbstractClassDiagramBuilder(MavenProject project, String prefix, String[] excludes, File header, File footer, boolean diagramWithDependencies, String linkPage) {
        this.project = project;
        this.prefix = prefix;
        this.excludes = excludes;
        this.header = header;
        this.footer = footer;
        this.diagramWithDependencies = diagramWithDependencies;
        this.linkPage = linkPage;
    }

    public abstract void filterOnAnnotation(Class<? extends Annotation> var1);

    public abstract String generate() throws MojoExecutionException;

    protected String readHeader() throws MojoExecutionException {
        return FileUtils.read(this.header);
    }

    protected String readFooter() throws MojoExecutionException {
        return FileUtils.read(this.footer);
    }

    protected Predicate<ClassPath.ClassInfo> defaultFilter() {
        return ci -> ci.getPackageName().startsWith(this.prefix) && !ci.getSimpleName().equalsIgnoreCase(PACKAGE_INFO) && !ci.getSimpleName().endsWith(TEST) && !ci.getSimpleName().endsWith(IT) && Arrays.stream(this.excludes).noneMatch(excl -> ci.getName().matches((String)excl));
    }

    protected ClassPath initClassPath() throws MojoExecutionException {
        try {
            return ClassPath.from((ClassLoader)ClassLoaderUtil.getRuntimeClassLoader(this.project));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to initialize classPath !", (Exception)e);
        }
    }

    public void mapNames(File mappings) throws MojoExecutionException {
        try {
            this.namesMapper = new GlossaryNamesMapper<UbiquitousLanguage>(mappings, UbiquitousLanguage.class);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error reading mappings file", (Exception)e);
        }
    }

    private Optional<Link> createLink(String label, Integer linkId, String defaultLinkId) {
        Link link = new Link();
        link.setLabel(label);
        link.setUrl(AnchorUtil.formatLinkWithPage(this.linkPage, linkId, defaultLinkId));
        return Optional.of(link);
    }

    public Optional<Link> getClassLink(Class aClass) {
        Integer id = AnnotationUtil.tryFind(aClass, UbiquitousLanguage.class).map(UbiquitousLanguage::id).orElse(null);
        String label = this.namesMapper.getClassName(aClass);
        return this.createLink(label, id, label);
    }

    public Optional<Link> getFieldLink(Field field) {
        String parentLabel = this.namesMapper.getClassName(field.getDeclaringClass());
        String label = this.namesMapper.getFieldName(field);
        Integer id = AnnotationUtil.tryFind(field, UbiquitousLanguage.class).map(UbiquitousLanguage::id).orElse(null);
        String defaultLinkId = AnchorUtil.glossaryLink(parentLabel, label);
        return this.createLink(label, id, defaultLinkId);
    }
}

