/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractGlossaryMojo;
import ch.ifocusit.livingdoc.plugin.glossary.JavaClass;
import ch.ifocusit.livingdoc.plugin.utils.MustacheUtil;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="dictionary", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class DictionaryMojo
extends AbstractGlossaryMojo {
    private static final String DEFAULT_DICTIONARY_TEMPLATE_MUSTACHE = "/default_dictionary_template.mustache";
    @Parameter(property="livingdoc.dictionary.output.filename", defaultValue="dictionary", required=true)
    private String dictionaryOutputFilename;
    @Parameter(property="livingdoc.dictionary.title")
    private String dictionaryTitle;
    @Parameter(property="livingdoc.dictionary.link.activate", defaultValue="true")
    private boolean dictionaryWithLink;
    @Parameter(property="livingdoc.dictionary.template")
    private File dictionaryTemplate;

    @Override
    protected String getOutputFilename() {
        return this.dictionaryOutputFilename;
    }

    @Override
    protected String getTitle() {
        return this.dictionaryTitle;
    }

    @Override
    protected void executeGlossaryMojo() throws Exception {
        List classes = this.getClasses().map(javaClass -> JavaClass.from(javaClass, this::hasAnnotation, this.getClasses().collect(Collectors.toList()), this)).sorted().collect(Collectors.toList());
        HashMap<String, Object> scopes = new HashMap<String, Object>();
        scopes.put("classes", classes);
        scopes.put("withLink", this.dictionaryWithLink);
        this.asciiDocBuilder.textLine(MustacheUtil.execute(this.dictionaryTemplate, DEFAULT_DICTIONARY_TEMPLATE_MUSTACHE, scopes));
        this.somethingWasGenerated = !classes.isEmpty();
    }
}

