/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin.publish.model;

import com.google.common.collect.Ordering;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class Page
implements Comparable<Page> {
    private String spaceKey;
    private String parentId;
    private String content;
    private Path file;
    private String title;
    private List<Attachement> attachements = new ArrayList<Attachement>();

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Path getFile() {
        return this.file;
    }

    public void setFile(Path file) {
        this.file = file;
    }

    public String getFileName() {
        return this.file.getFileName().toString();
    }

    public List<Attachement> getAttachements() {
        return this.attachements;
    }

    public void addAttachement(String name, String fileName) {
        Attachement attachement = new Attachement();
        attachement.name = name;
        attachement.file = Paths.get(this.file.getParent().toFile().getAbsolutePath(), fileName);
        this.attachements.add(attachement);
    }

    @Override
    public int compareTo(Page o) {
        return Ordering.from(Comparator.comparing(Page::getFileName)).compare((Object)this, (Object)o);
    }

    public static class Attachement {
        String name;
        Path file;

        public String getName() {
            return this.name;
        }

        public Path getFile() {
            return this.file;
        }
    }
}

