/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.common.Template;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.OptionsBuilder;
import org.asciidoctor.SafeMode;

public abstract class CommonMojoDefinition
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${project.build.directory}/generated-docs", required=true)
    protected File outputDirectory;
    @Parameter
    protected String outputFilename;
    @Parameter(defaultValue="html")
    protected Format format;
    @Parameter
    protected Template template;

    void write(String newValue, File output) throws MojoExecutionException {
        this.write(newValue, output, null);
    }

    void write(String newValue, File output, Template template) throws MojoExecutionException {
        String newContent = template == null ? newValue : template.process(newValue);
        try {
            output.getParentFile().mkdirs();
            IOUtils.write((String)newContent, (OutputStream)new FileOutputStream(output), (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to write output file '%s' !", output), (Exception)e);
        }
    }

    void write(AsciiDocBuilder asciiDocBuilder) throws MojoExecutionException {
        this.outputDirectory.mkdirs();
        File output = this.getOutput(Format.adoc);
        try {
            asciiDocBuilder.writeToFile(this.outputDirectory.getAbsolutePath(), this.getFilenameWithoutExtension(), StandardCharsets.UTF_8);
            if (Format.html.equals((Object)this.format)) {
                Asciidoctor asciidoctor = Asciidoctor.Factory.create();
                asciidoctor.requireLibrary(new String[]{"asciidoctor-diagram"});
                asciidoctor.convertFile(output, OptionsBuilder.options().backend("html5").safe(SafeMode.UNSAFE).asMap());
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(String.format("Unable to convert asciidoc file '%s' to html !", output.getAbsolutePath()), (Exception)e);
        }
    }

    protected abstract String getDefaultFilename();

    protected String getFilename() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.outputFilename, (CharSequence)this.getDefaultFilename());
    }

    protected String getFilenameWithoutExtension() {
        String filename = this.getFilename();
        return filename.indexOf(".") > 0 ? filename.substring(0, filename.lastIndexOf(".")) : filename;
    }

    protected File getOutput(Format desiredExtension) {
        String filename = (String)StringUtils.defaultIfBlank((CharSequence)this.outputFilename, (CharSequence)this.getDefaultFilename());
        filename = filename.endsWith("." + desiredExtension.name()) ? filename : filename + "." + (Object)((Object)desiredExtension);
        return new File(this.outputDirectory, filename);
    }

    public static enum Format {
        asciidoc,
        adoc,
        html,
        plantuml;

    }
}

