/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.CommonGlossaryMojoDefinition;
import ch.ifocusit.livingdoc.plugin.mapping.MappingDefinition;
import com.thoughtworks.qdox.model.JavaAnnotatedElement;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="glossary", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class GlossaryMojo
extends CommonGlossaryMojoDefinition {
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String HEADER = "[[glossaryid-{0}]]\n=== #{0}# - {1}";
    public static final String HEADER_LITE = "[[glossaryid-{0}]]\n=== {1}";
    @Parameter
    private String glossaryTemplate;

    @Override
    protected String getDefaultFilename() {
        return "glossary";
    }

    @Override
    protected String getTitle() {
        return "UbiquitousLanguage";
    }

    @Override
    protected void executeMojo() {
        ArrayList definitions = new ArrayList();
        this.getClasses().forEach(javaClass -> {
            definitions.add(this.map((JavaAnnotatedElement)javaClass, javaClass.getName(), javaClass.getComment()));
            javaClass.getFields().stream().filter(this::hasAnnotation).forEach(javaField -> definitions.add(this.map((JavaAnnotatedElement)javaField, javaField.getName(), javaField.getComment())));
        });
        definitions.stream().sorted().filter(GlossaryMojo.distinctByKey()).forEach(this::addGlossarEntry);
    }

    private void addGlossarEntry(MappingDefinition def) {
        String text = MessageFormat.format(def.getId() == null ? HEADER_LITE : HEADER, this.defaultString(def.getId(), this.idFromName(def)), def.getName());
        if (StringUtils.isNotBlank((CharSequence)this.glossaryTemplate)) {
            text = MessageFormat.format(this.glossaryTemplate, this.defaultString(def.getId(), this.idFromName(def)), def.getName());
        }
        this.asciiDocBuilder.textLine(text.replace("\\r\\n", NEWLINE).replace("\\n", NEWLINE));
        this.asciiDocBuilder.textLine(def.getDescription());
        this.asciiDocBuilder.textLine("");
    }
}

