/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.CommonMojoDefinition;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="gherkin", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class GherkinMojo
extends CommonMojoDefinition {
    @Parameter(defaultValue="${project.basedir}/src/test/resources/features")
    private List<String> features;
    @Parameter(defaultValue="")
    private String options;

    @Override
    protected String getDefaultFilename() {
        return "gherkin";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        AsciiDocBuilder asciiDocBuilder = this.createAsciiDocBuilder();
        if (CommonMojoDefinition.Format.html.equals((Object)this.format)) {
            asciiDocBuilder.sectionTitleLevel1("Business requirements");
        }
        asciiDocBuilder.textLine("");
        this.features.forEach(path -> {
            try {
                if (Files.notExists(Paths.get(path, new String[0]), new LinkOption[0])) {
                    return;
                }
                Files.walk(Paths.get(path, new String[0]), new FileVisitOption[0]).filter(p -> p.toString().endsWith(".feature")).map(Path::toString).forEach(p -> asciiDocBuilder.textLine(String.format("gherkin::%s[%s]", p, this.options)));
            }
            catch (IOException e) {
                throw new IllegalStateException(String.format("Error browsing %s", path), e);
            }
        });
        asciiDocBuilder.textLine("");
        this.write(asciiDocBuilder);
    }
}

