/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.plugin.CommonGlossaryMojoDefinition;
import ch.ifocusit.livingdoc.plugin.mapping.DomainObject;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="glossary", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class GlossaryMojo
extends CommonGlossaryMojoDefinition {
    @Override
    protected String getDefaultFilename() {
        return "glossary";
    }

    @Override
    protected String getTitle() {
        return "Glossary";
    }

    @Override
    protected void executeMojo(Stream<DomainObject> domainObjects) {
        domainObjects.forEach(this::addGlossarEntry);
    }

    private void addGlossarEntry(DomainObject domainObject) {
        this.asciiDocBuilder.textLine(this.formatAndLink(StringUtils.defaultString((String)this.glossaryTitleTemplate, (String)(domainObject.getId() != null ? "[[{2}]]\n=== #{0}# - {1}" : "[[{2}]]\n=== {1}")), domainObject));
        this.asciiDocBuilder.textLine(domainObject.getDescription());
        this.asciiDocBuilder.textLine("");
    }
}

