/*
 * Decompiled with CFR 0.152.
 */
package ch.ifocusit.livingdoc.plugin;

import ch.ifocusit.livingdoc.annotations.UbiquitousLanguage;
import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractAsciidoctorMojo;
import ch.ifocusit.livingdoc.plugin.baseMojo.AbstractDocsGeneratorMojo;
import ch.ifocusit.livingdoc.plugin.diagram.PlantumlClassDiagramBuilder;
import ch.ifocusit.livingdoc.plugin.domain.Cluster;
import ch.ifocusit.livingdoc.plugin.domain.Color;
import io.github.robwin.markup.builder.asciidoc.AsciiDocBuilder;
import java.io.File;
import java.util.List;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="diagram", requiresDependencyResolution=ResolutionScope.RUNTIME_PLUS_SYSTEM)
public class DiagramMojo
extends AbstractDocsGeneratorMojo {
    private static final Color DEFAULT_ROOT_COLOR = Color.from("wheat", null);
    @Parameter(required=true)
    private String packageRoot;
    @Parameter
    private String[] excludes = new String[0];
    @Parameter(defaultValue="plantuml", required=true)
    private DiagramType diagramType;
    @Parameter(defaultValue="png", required=true)
    private DiagramImageType diagramImageType;
    @Parameter(defaultValue="true")
    private boolean withLink = true;
    @Parameter(defaultValue="glossary.html")
    private String diagramLinkPage;
    @Parameter
    private Color rootAggregateColor = DEFAULT_ROOT_COLOR;
    @Parameter(defaultValue="true")
    private boolean detectCluster = true;
    @Parameter
    private List<Cluster> clusters;
    @Parameter(defaultValue="src/main/livingdoc/diagram.header")
    private File header;
    @Parameter(defaultValue="src/main/livingdoc/diagram.footer")
    private File footer;
    @Parameter(defaultValue="false")
    private boolean interactive = false;

    @Override
    protected String getDefaultFilename() {
        return "diagram";
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.interactive) {
            this.withLink = true;
            this.diagramImageType = DiagramImageType.svg;
        }
        String diagram = this.generateDiagram();
        switch (this.format) {
            case html: 
            case adoc: 
            case asciidoc: {
                AsciiDocBuilder asciiDocBuilder = this.createAsciiDocBuilder();
                if (AbstractAsciidoctorMojo.Format.html.equals((Object)this.format)) {
                    asciiDocBuilder.documentTitle("Class diagram");
                }
                switch (this.diagramType) {
                    case plantuml: {
                        asciiDocBuilder.textLine(String.format("[plantuml, %s, format=%s, opts=interactive]", new Object[]{this.getOutputFilename(), this.diagramImageType}));
                    }
                }
                asciiDocBuilder.textLine("----");
                asciiDocBuilder.textLine(diagram);
                asciiDocBuilder.textLine("----");
                this.write(asciiDocBuilder);
                break;
            }
            case plantuml: {
                this.write(diagram, this.getOutput(this.getOutputFilename(), AbstractAsciidoctorMojo.Format.plantuml));
            }
        }
    }

    String generateDiagram() throws MojoExecutionException {
        switch (this.diagramType) {
            case plantuml: {
                PlantumlClassDiagramBuilder builder = new PlantumlClassDiagramBuilder(this.project, this.packageRoot, this.excludes, this.rootAggregateColor, this.header, this.footer);
                if (this.onlyAnnotated) {
                    builder.filterOnAnnotation(UbiquitousLanguage.class);
                }
                if (this.withLink && !DiagramImageType.png.equals((Object)this.diagramImageType)) {
                    builder.mapNames(this.glossaryMapping, UbiquitousLanguage.class, this.diagramLinkPage + "#" + this.glossaryAnchorTemplate);
                }
                return builder.generate();
            }
        }
        throw new NotImplementedException(String.format("format %s is not implemented yet", new Object[]{this.diagramType}));
    }

    public static enum DiagramImageType {
        png,
        svg,
        txt;

    }

    public static enum DiagramType {
        plantuml;

    }
}

